<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-900 antialiased">
        <div class="min-h-screen bg-brand-gradient flex flex-col items-center justify-center px-4 py-10 relative overflow-hidden">
            <div class="absolute -top-24 -left-16 h-80 w-80 rounded-full bg-sky-400/30 blur-3xl animate-pulse"></div>
            <div class="absolute top-1/2 -right-16 h-96 w-96 rounded-full bg-blue-700/20 blur-3xl animate-pulse"></div>
            <div class="w-full max-w-4xl grid grid-cols-1 lg:grid-cols-2 gap-6 items-stretch">
                <div class="hidden lg:flex flex-col justify-between p-8 rounded-2xl bg-white/80 backdrop-blur ring-1 ring-gray-100">
                    <div class="flex items-center">
                        <x-application-logo class="h-14 w-auto" />
                    </div>
                    <div class="mt-4 space-y-3 max-w-md">
                        <div class="text-3xl md:text-[34px] font-semibold leading-tight tracking-wide bg-gradient-to-r from-blue-900 via-blue-700 to-sky-500 bg-clip-text text-transparent">
                            Community Management Suite
                        </div>
                        <p class="text-base leading-7 text-gray-600">Track cases, sentiment, and client outcomes with clarity. Secure, fast, and built for agency workflows.</p>
                    </div>
                    <div class="text-xs text-gray-500">Secure Agency Workspace</div>
                </div>

                <div class="w-full px-6 py-8 bg-white/95 backdrop-blur rounded-2xl shadow-lg ring-1 ring-gray-100">
                    <div class="flex items-center lg:hidden mb-6">
                        <x-application-logo class="h-12 w-auto" />
                    </div>
                    {{ $slot }}
                </div>
            </div>
        </div>
    </body>
</html>
