<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
</head>
<body style="font-family: Arial, sans-serif; color: #111827; line-height: 1.5;">
    <h2 style="margin-bottom: 4px;">Automated Case Report</h2>
    <p style="margin-top:0; color:#6b7280;">Rule: {{ $rule->name }} | Scope: {{ $rule->is_global ? 'Global' : 'Client' }}</p>

    @foreach(($blocks ?? []) as $block)
        @if($block === 'custom_message' && !empty($renderedBody))
            <h3>Message</h3>
            <div style="margin: 10px 0 18px; padding: 12px; background: #f8fafc; border: 1px solid #e5e7eb; border-radius: 6px;">
                {!! nl2br(e($renderedBody)) !!}
            </div>
        @endif

        @if($block === 'client_info')
            <h3>Client Info</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Field</th><th align="left">Value</th></tr>
                <tr><td>Client</td><td>{{ $clientInfo['name'] ?? 'N/A' }}</td></tr>
                <tr><td>Scope</td><td>{{ $clientInfo['scope'] ?? 'N/A' }}</td></tr>
                <tr><td>Timezone</td><td>{{ $clientInfo['timezone'] ?? 'N/A' }}</td></tr>
                <tr><td>Date Range</td><td>{{ $clientInfo['date_from'] ?? 'N/A' }} to {{ $clientInfo['date_to'] ?? 'N/A' }}</td></tr>
                <tr><td>Default Notification Emails</td><td>{{ implode(', ', $clientInfo['default_notification_emails'] ?? []) ?: 'N/A' }}</td></tr>
            </table>
        @endif

        @if($block === 'summary_kpis')
            <h3>Summary</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:16px 0; border-color:#e5e7eb; font-size:14px;">
                <tr><th align="left">Metric</th><th align="left">Value</th></tr>
                <tr><td>Total Cases</td><td>{{ $summary['total'] }}</td></tr>
                <tr><td>Open</td><td>{{ $summary['open'] }}</td></tr>
                <tr><td>In Progress</td><td>{{ $summary['in_progress'] }}</td></tr>
                <tr><td>Waiting for User</td><td>{{ $summary['waiting'] }}</td></tr>
                <tr><td>Resolved</td><td>{{ $summary['resolved'] }}</td></tr>
                <tr><td>Closed</td><td>{{ $summary['closed'] }}</td></tr>
                <tr><td>Critical (not closed)</td><td>{{ $summary['critical'] }}</td></tr>
            </table>
        @endif

        @if($block === 'status_breakdown')
            <h3>Status Breakdown</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Status</th><th align="left">Count</th></tr>
                @forelse($statusBreakdown as $k => $v)
                    <tr><td>{{ $k }}</td><td>{{ $v }}</td></tr>
                @empty
                    <tr><td colspan="2">No data.</td></tr>
                @endforelse
            </table>
        @endif

        @if($block === 'sentiment_breakdown')
            <h3>Sentiment Breakdown</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Sentiment</th><th align="left">Count</th></tr>
                @forelse($sentimentBreakdown as $k => $v)
                    <tr><td>{{ $k }}</td><td>{{ $v }}</td></tr>
                @empty
                    <tr><td colspan="2">No data.</td></tr>
                @endforelse
            </table>
        @endif

        @if($block === 'open_cases_table')
            <h3>Open / Active Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Sentiment</th><th align="left">Status</th><th align="left">Updated</th><th align="left">Link</th>
                </tr>
                @forelse($openCases as $case)
                    <tr>
                        <td>#{{ $case['id'] }}</td><td>{{ $case['client'] }}</td><td>{{ $case['label'] }}</td><td>{{ $case['sentiment'] }}</td><td>{{ $case['status'] }}</td><td>{{ $case['updated_at'] }}</td><td><a href="{{ $case['url'] }}">Open Case</a></td>
                    </tr>
                @empty
                    <tr><td colspan="7">No open cases.</td></tr>
                @endforelse
            </table>
        @endif

        @if($block === 'closed_cases_table')
            <h3>Closed Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Sentiment</th><th align="left">Closed At</th>
                </tr>
                @forelse($closedCases as $case)
                    <tr>
                        <td>#{{ $case['id'] }}</td><td>{{ $case['client'] }}</td><td>{{ $case['label'] }}</td><td>{{ $case['sentiment'] }}</td><td>{{ $case['closed_at'] }}</td>
                    </tr>
                @empty
                    <tr><td colspan="5">No closed cases.</td></tr>
                @endforelse
            </table>
        @endif

        @if($block === 'critical_cases_table')
            <h3>Critical Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Status</th><th align="left">Updated</th><th align="left">Link</th>
                </tr>
                @forelse($criticalCases as $case)
                    <tr>
                        <td>#{{ $case['id'] }}</td><td>{{ $case['client'] }}</td><td>{{ $case['label'] }}</td><td>{{ $case['status'] }}</td><td>{{ $case['updated_at'] }}</td><td><a href="{{ $case['url'] }}">Open Case</a></td>
                    </tr>
                @empty
                    <tr><td colspan="6">No critical cases.</td></tr>
                @endforelse
            </table>
        @endif
    @endforeach
</body>
</html>
