<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin Dashboard</h2>
            <div class="text-sm text-gray-500">Global overview</div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Total Clients</div>
                    <div class="text-2xl font-semibold">{{ $kpis['clients'] }}</div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Total Cases</div>
                    <div class="text-2xl font-semibold">{{ $kpis['total_cases'] }}</div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Overdue (>{{ $charts['sla_threshold_hours'] }}h)</div>
                    <div class="text-2xl font-semibold text-rose-600">{{ $kpis['overdue_cases'] }}</div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Critical Open</div>
                    <div class="text-2xl font-semibold text-amber-600">{{ $kpis['critical_cases'] }}</div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
                <a href="{{ route('admin.users.index') }}" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Manage Users</div>
                    <div class="text-lg font-semibold text-gray-800">Users & Roles</div>
                </a>
                <a href="{{ route('admin.clients.index') }}" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Manage Clients</div>
                    <div class="text-lg font-semibold text-gray-800">Clients & Labels</div>
                </a>
                <a href="{{ route('admin.assignments.index') }}" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Assignments</div>
                    <div class="text-lg font-semibold text-gray-800">User ↔ Client</div>
                </a>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-6">
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Cases Trend (14 days)</div>
                    <div class="chart-wrap">
                        <canvas id="trendChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Sentiment Distribution</div>
                    <div class="chart-wrap">
                        <canvas id="sentimentChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Top Labels</div>
                    <div class="chart-wrap">
                        <canvas id="labelsChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Sources Mix</div>
                    <div class="chart-wrap">
                        <canvas id="sourcesChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="card p-6 mt-6">
                <div class="flex items-center justify-between mb-3">
                    <div class="text-sm font-semibold text-gray-700">Automatic Report Logs</div>
                    <a href="{{ route('admin.report-rules.index') }}" class="text-sm text-[color:var(--brand-primary)] hover:underline">Manage Rules</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="text-gray-500">
                            <tr>
                                <th class="px-3 py-2 text-left">Time</th>
                                <th class="px-3 py-2 text-left">Rule</th>
                                <th class="px-3 py-2 text-left">Status</th>
                                <th class="px-3 py-2 text-left">Recipients</th>
                                <th class="px-3 py-2 text-left">Cases</th>
                                <th class="px-3 py-2 text-left">Manual</th>
                                <th class="px-3 py-2"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($reportLogs as $log)
                                <tr class="border-t">
                                    <td class="px-3 py-2">{{ $log->ran_at }}</td>
                                    <td class="px-3 py-2">{{ $log->rule->name ?? '-' }}</td>
                                    <td class="px-3 py-2">{{ $log->status }}</td>
                                    <td class="px-3 py-2">{{ $log->recipient_count }}</td>
                                    <td class="px-3 py-2">{{ $log->case_count }}</td>
                                    <td class="px-3 py-2">{{ $log->is_manual ? 'Yes' : 'No' }}</td>
                                    <td class="px-3 py-2 text-right">
                                        @if($log->rule)
                                            <form method="POST" action="{{ route('admin.report-rules.run-now', $log->rule) }}" class="inline">
                                                @csrf
                                                <button class="text-emerald-600 hover:underline">Run Again</button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="7" class="px-3 py-3 text-gray-500">No report runs yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
            const trendLabels = @json($charts['trend_labels']);
            const trendCounts = @json($charts['trend_counts']);
            const sentimentLabels = @json($charts['sentiment_labels']);
            const sentimentCounts = @json($charts['sentiment_counts']);
            const labelLabels = @json($charts['label_labels']);
            const labelCounts = @json($charts['label_counts']);
            const sourceLabels = @json($charts['source_labels']);
            const sourceCounts = @json($charts['source_counts']);

            if (!window.Chart) return;
            const getVar = (name, fallback) => getComputedStyle(document.documentElement).getPropertyValue(name).trim() || fallback;
            const primary = getVar('--brand-primary', '#1e3a8a');
            const accent = getVar('--brand-accent', '#38bdf8');

            new Chart(document.getElementById('trendChart'), {
                type: 'line',
                data: {
                    labels: trendLabels,
                    datasets: [{
                        label: 'Cases',
                        data: trendCounts,
                        borderColor: primary,
                        backgroundColor: 'rgba(56,189,248,0.2)',
                        tension: 0.3,
                        fill: true,
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('sentimentChart'), {
                type: 'doughnut',
                data: {
                    labels: sentimentLabels,
                    datasets: [{
                        data: sentimentCounts,
                        backgroundColor: ['#22c55e', '#94a3b8', '#ef4444', '#b91c1c'],
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('labelsChart'), {
                type: 'bar',
                data: {
                    labels: labelLabels,
                    datasets: [{
                        label: 'Cases',
                        data: labelCounts,
                        backgroundColor: accent
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('sourcesChart'), {
                type: 'bar',
                data: {
                    labels: sourceLabels,
                    datasets: [{
                        label: 'Cases',
                        data: sourceCounts,
                        backgroundColor: primary
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });
            });
        </script>
        <style>
            #trendChart, #sentimentChart, #labelsChart, #sourcesChart { height: 280px; }
        </style>
    @endpush
</x-app-layout>
