<x-guest-layout>
    <div class="mb-6">
        <h1 class="text-2xl font-semibold text-gray-900">Contact Us (Mail Test)</h1>
        <p class="text-sm text-gray-600">Use this page to test SMTP/Mailtrap delivery.</p>
    </div>

    @if (session('status'))
        <div class="mb-4 bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-md">
            {{ session('status') }}
        </div>
    @endif

    <form method="POST" action="{{ route('contact.store') }}" class="space-y-4">
        @csrf
        <div>
            <label class="block text-sm font-medium text-gray-700">Name</label>
            <input type="text" name="name" value="{{ old('name') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
            @error('name') <div class="text-sm text-rose-600 mt-1">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Email</label>
            <input type="email" name="email" value="{{ old('email') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
            @error('email') <div class="text-sm text-rose-600 mt-1">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Subject</label>
            <input type="text" name="subject" value="{{ old('subject', 'SMTP Test') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
            @error('subject') <div class="text-sm text-rose-600 mt-1">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Message</label>
            <textarea name="message" rows="5" class="mt-1 w-full border-gray-300 rounded-md" required>{{ old('message', 'Hello, this is a Mailtrap test message.') }}</textarea>
            @error('message') <div class="text-sm text-rose-600 mt-1">{{ $message }}</div> @enderror
        </div>

        <button class="w-full btn-primary justify-center">Send Test Email</button>
    </form>
</x-guest-layout>
