<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <div class="text-xs uppercase tracking-wide text-gray-500">Case Details</div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">Case #{{ $case->id }}</h2>
            </div>
            <div class="flex items-center gap-2">
                @can('cases.edit')
                    <a href="{{ route('cases.edit', $case) }}" class="btn-primary">Edit</a>
                @endcan
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="card p-6 bg-gradient-to-br from-white via-blue-50/30 to-sky-50/40">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div class="rounded-xl bg-gradient-to-br from-blue-50 to-sky-50 p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Client</div>
                        <div class="text-base font-semibold text-gray-900">{{ $case->client->name ?? '—' }}</div>
                    </div>
                    <div class="rounded-xl bg-gradient-to-br from-blue-50 to-sky-50 p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Label</div>
                        <div class="text-base font-semibold text-gray-900">{{ $case->label }}</div>
                    </div>
                    <div class="rounded-xl bg-gradient-to-br from-blue-50 to-sky-50 p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Status</div>
                        <div class="inline-flex items-center gap-2 mt-1">
                            <span class="badge-status">{{ $case->status }}</span>
                        </div>
                    </div>
                    <div class="rounded-xl bg-gradient-to-br from-blue-50 to-sky-50 p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Sentiment</div>
                        <div class="mt-1">
                            @php
                                $sentimentClass = match ($case->sentiment) {
                                    'Positive' => 'sentiment-positive',
                                    'Neutral' => 'sentiment-neutral',
                                    'Negative' => 'sentiment-negative',
                                    'Critical' => 'sentiment-critical',
                                    default => 'badge-status',
                                };
                            @endphp
                            <span class="{{ $sentimentClass }}">{{ $case->sentiment }}</span>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Source</div>
                        <div class="text-sm mt-1">{{ $case->source }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Post Date / Time</div>
                        <div class="text-sm mt-1">{{ $case->post_date?->format('Y-m-d') }} {{ $case->post_time }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Created By</div>
                        <div class="text-sm mt-1">{{ $case->creator->name ?? '—' }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Created</div>
                        <div class="text-sm mt-1">{{ $case->created_at?->toDayDateTimeString() }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Last Updated</div>
                        <div class="text-sm mt-1">{{ $case->updated_at?->toDayDateTimeString() }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Closed At</div>
                        <div class="text-sm mt-1">{{ $case->closed_at?->toDayDateTimeString() ?? '—' }}</div>
                    </div>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mt-4">
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Original Post</div>
                        <div class="text-sm text-gray-700 whitespace-pre-line mt-1">{{ $case->post_text ?? '—' }}</div>
                    </div>
                    <div class="rounded-xl bg-white p-4 ring-1 ring-blue-100">
                        <div class="text-xs text-gray-500">Translation</div>
                        <div class="text-sm text-gray-700 whitespace-pre-line mt-1">{{ $case->translation ?? '—' }}</div>
                        <div class="mt-3 pt-3 border-t border-gray-100">
                            <div class="text-xs text-gray-500">Post Link</div>
                            <div class="text-sm mt-1">
                                @if ($case->post_link)
                                    <a href="{{ $case->post_link }}" target="_blank" class="text-blue-600 hover:underline">{{ $case->post_link }}</a>
                                @else
                                    —
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 space-y-6">
                    <div class="card p-6 bg-white/95">
                        <div class="text-sm font-semibold text-gray-700">Activity Log</div>
                        <div class="mt-3 space-y-3">
                            @forelse ($activities as $activity)
                                @php
                                    $kind = 'General Update';
                                    $properties = json_decode($activity->properties ?? '{}', true) ?: [];
                                    $attrs = $properties['attributes'] ?? [];
                                    $old = $properties['old'] ?? [];

                                    if (($activity->description ?? '') === 'alert email sent') {
                                        $kind = 'Alert Email Sent';
                                    } elseif (array_key_exists('status', $attrs) && (($old['status'] ?? null) !== ($attrs['status'] ?? null))) {
                                        $kind = 'Status Change';
                                    } elseif (array_key_exists('notes_social', $attrs)) {
                                        $kind = 'Notes Update';
                                    } elseif (array_key_exists('action_social', $attrs)) {
                                        $kind = 'Action Update';
                                    } elseif (($activity->event ?? null) === 'created') {
                                        $kind = 'Case Created';
                                    }
                                @endphp
                                <div class="border border-gray-100 rounded-lg p-3 text-sm">
                                    <div class="flex items-center justify-between gap-2">
                                        <div class="text-gray-800">{{ $activity->description }}</div>
                                        <span class="chip bg-blue-50 text-blue-700">{{ $kind }}</span>
                                    </div>
                                    <div class="text-xs text-gray-500">
                                        {{ $activity->created_at }} · by {{ $activity->causer_name ?? 'System' }}
                                    </div>
                                </div>
                            @empty
                                <div class="text-sm text-gray-500">No activity yet.</div>
                            @endforelse
                        </div>
                    </div>

                    <div class="card p-6 bg-white/95">
                        <div class="text-sm font-semibold text-gray-700">Comments</div>
                        <div class="mt-3 space-y-3">
                            @forelse ($case->comments as $comment)
                                <div class="border border-gray-100 rounded-lg p-3 text-sm">
                                    <div class="text-gray-800 whitespace-pre-line">{{ $comment->body }}</div>
                                    <div class="text-xs text-gray-500">{{ $comment->user->name ?? '—' }} · {{ $comment->created_at?->diffForHumans() }}</div>
                                </div>
                            @empty
                                <div class="text-sm text-gray-500">No comments yet.</div>
                            @endforelse
                        </div>
                        @can('cases.edit')
                            <form method="POST" action="{{ route('cases.comments.store', $case) }}" class="mt-4">
                                @csrf
                                <textarea name="body" rows="3" class="w-full border-gray-300 rounded-md" placeholder="Add a comment..."></textarea>
                                @error('body')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                                <div class="mt-2 flex justify-end">
                                    <button class="btn-primary">Add Comment</button>
                                </div>
                            </form>
                        @endcan
                    </div>
                </div>

                <div class="space-y-6">
                    <div class="card p-6 bg-white/95">
                        <div class="text-sm font-semibold text-gray-700">Assigned Owners</div>
                        <div class="mt-3 space-y-2">
                            @forelse ($case->owners as $owner)
                                <div class="text-sm text-gray-700">{{ $owner->name }}</div>
                            @empty
                                <div class="text-sm text-gray-500">No owners assigned.</div>
                            @endforelse
                        </div>
                        @can('cases.edit')
                            <form method="POST" action="{{ route('cases.owners.update', $case) }}" class="mt-4">
                                @csrf
                                <label class="block text-xs text-gray-500">Update owners</label>
                                <select name="owner_ids[]" multiple class="mt-1 w-full border-gray-300 rounded-md">
                                    @foreach ($ownerCandidates as $owner)
                                        <option value="{{ $owner->id }}" @selected($case->owners->pluck('id')->contains($owner->id))>
                                            {{ $owner->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="mt-2 flex justify-end">
                                    <button class="btn-primary">Save Owners</button>
                                </div>
                            </form>
                        @endcan
                    </div>

                    <div class="card p-6 bg-white/95">
                        <div class="text-sm font-semibold text-gray-700">Agency Notes</div>
                        <div class="mt-2 text-sm text-gray-700 whitespace-pre-line">{{ $case->notes_social ?? '—' }}</div>
                        <div class="mt-4">
                            <div class="text-xs text-gray-500">Action (Social Media Team)</div>
                            <div class="text-sm">{{ $case->action_social ?? '—' }}</div>
                        </div>
                        <div class="mt-4">
                            <div class="text-xs text-gray-500">User Reply</div>
                            <div class="text-sm">{{ $case->user_reply ?? '—' }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
