@php
    $selected = $selected ?? [];
    $rawPostDate = old('post_date', $selected['post_date'] ?? '');
    $rawPostTime = old('post_time', $selected['post_time'] ?? '');

    try {
        $postDateValue = $rawPostDate ? \Illuminate\Support\Carbon::parse($rawPostDate)->format('Y-m-d') : '';
    } catch (\Throwable $e) {
        $postDateValue = '';
    }

    try {
        $postTimeValue = $rawPostTime ? \Illuminate\Support\Carbon::parse($rawPostTime)->format('H:i') : '';
    } catch (\Throwable $e) {
        $postTimeValue = preg_match('/^\d{2}:\d{2}$/', (string) $rawPostTime) ? $rawPostTime : '';
    }
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Client</label>
        <select id="clientSelect" name="client_id" class="mt-1 w-full border-gray-300 rounded-md" required>
            @foreach ($clients as $client)
                <option value="{{ (int) $client->id }}" @selected((int) old('client_id', $selected['client_id'] ?? 0) === (int) $client->id)>
                    {{ $client->name }}
                </option>
            @endforeach
        </select>
        @error('client_id')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Label</label>
        <select id="labelSelect" name="label" class="mt-1 w-full border-gray-300 rounded-md">
            @foreach ($options['label'] as $value)
                <option value="{{ $value }}" @selected(old('label', $selected['label'] ?? '') == $value)>{{ $value }}</option>
            @endforeach
        </select>
        @error('label')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Source</label>
        <select name="source" class="mt-1 w-full border-gray-300 rounded-md">
            @foreach ($options['source'] as $value)
                <option value="{{ $value }}" @selected(old('source', $selected['source'] ?? '') == $value)>{{ $value }}</option>
            @endforeach
        </select>
        @error('source')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Sentiment</label>
        <select name="sentiment" class="mt-1 w-full border-gray-300 rounded-md">
            @foreach ($options['sentiment'] as $value)
                <option value="{{ $value }}" @selected(old('sentiment', $selected['sentiment'] ?? '') == $value)>{{ $value }}</option>
            @endforeach
        </select>
        @error('sentiment')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Post Date</label>
        <input type="date" name="post_date" value="{{ $postDateValue }}" class="mt-1 w-full border-gray-300 rounded-md" />
        @error('post_date')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Post Time</label>
        <input type="time" name="post_time" value="{{ $postTimeValue }}" class="mt-1 w-full border-gray-300 rounded-md" />
        @error('post_time')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Post Link</label>
        <input type="text" name="post_link" value="{{ old('post_link', $selected['post_link'] ?? '') }}" class="mt-1 w-full border-gray-300 rounded-md" />
        @error('post_link')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Action (Social Media Team)</label>
        <select name="action_social" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="">—</option>
            @foreach ($options['action_social'] as $value)
                <option value="{{ $value }}" @selected(old('action_social', $selected['action_social'] ?? '') == $value)>{{ $value }}</option>
            @endforeach
        </select>
        @error('action_social')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Status</label>
        <select name="status" class="mt-1 w-full border-gray-300 rounded-md">
            @foreach ($options['status'] as $value)
                <option value="{{ $value }}" @selected(old('status', $selected['status'] ?? '') == $value)>{{ $value }}</option>
            @endforeach
        </select>
        @error('status')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Original Post Text</label>
    <textarea name="post_text" rows="3" class="mt-1 w-full border-gray-300 rounded-md">{{ old('post_text', $selected['post_text'] ?? '') }}</textarea>
    @error('post_text')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Translation</label>
    <textarea name="translation" rows="2" class="mt-1 w-full border-gray-300 rounded-md">{{ old('translation', $selected['translation'] ?? '') }}</textarea>
    @error('translation')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
</div>

<div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Notes (Social Media Team)</label>
        <textarea name="notes_social" rows="3" class="mt-1 w-full border-gray-300 rounded-md">{{ old('notes_social', $selected['notes_social'] ?? '') }}</textarea>
        @error('notes_social')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">User Reply Info</label>
        <textarea name="user_reply" rows="3" class="mt-1 w-full border-gray-300 rounded-md">{{ old('user_reply', $selected['user_reply'] ?? '') }}</textarea>
        @error('user_reply')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
    </div>
</div>
