<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Report Rules</h2>
            <a href="{{ route('admin.report-rules.create') }}" class="btn-primary">New Rule</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left">Name</th>
                            <th class="px-4 py-3 text-left">Scope</th>
                            <th class="px-4 py-3 text-left">Trigger</th>
                            <th class="px-4 py-3 text-left">Interval</th>
                            <th class="px-4 py-3 text-left">Enabled</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($rules as $rule)
                            <tr class="border-t">
                                <td class="px-4 py-3">{{ $rule->name }}</td>
                                <td class="px-4 py-3">{{ $rule->is_global ? 'Global' : ($rule->client->name ?? 'Client') }}</td>
                                <td class="px-4 py-3">
                                    Status: {{ implode(', ', $rule->statuses ?? []) }}
                                    @if(!empty($rule->trigger_actions))
                                        <br><span class="text-xs text-gray-500">Action: {{ implode(', ', $rule->trigger_actions) }}</span>
                                    @endif
                                </td>
                                <td class="px-4 py-3">Every {{ $rule->check_every_minutes }} min</td>
                                <td class="px-4 py-3">{{ $rule->enabled ? 'Yes' : 'No' }}</td>
                                <td class="px-4 py-3 text-right">
                                    <form method="POST" action="{{ route('admin.report-rules.run-now', $rule) }}" class="inline">
                                        @csrf
                                        <button class="text-emerald-600 hover:underline">Run Now</button>
                                    </form>
                                    <a href="{{ route('admin.report-rules.edit', $rule) }}" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    <form method="POST" action="{{ route('admin.report-rules.destroy', $rule) }}" class="inline" onsubmit="return confirm('Delete this report rule?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="px-4 py-6 text-center text-gray-500">No report rules yet.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">{{ $rules->links() }}</div>
        </div>
    </div>
</x-app-layout>
