<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class DefaultRolesAndPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            'clients.manage',
            'users.manage',
            'assignments.manage',
            'cases.create',
            'cases.edit',
            'cases.close',
            'cases.view',
            'cases.export',
            'dashboards.view',
            'rules.manage',
            'custom_fields.manage',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        $roles = [
            'Super Admin' => $permissions,
            'Account Director' => [
                'assignments.manage',
                'cases.view',
                'cases.edit',
                'cases.close',
                'cases.export',
                'dashboards.view',
            ],
            'Community Team Member' => [
                'cases.create',
                'cases.edit',
                'cases.view',
                'dashboards.view',
            ],
            'Listening Team Member' => [
                'cases.create',
                'cases.edit',
                'cases.view',
                'dashboards.view',
            ],
            'CS Team Member' => [
                'cases.view',
                'cases.edit',
                'dashboards.view',
            ],
            'Client Viewer' => [
                'cases.view',
                'cases.export',
                'dashboards.view',
            ],
        ];

        foreach ($roles as $role => $rolePermissions) {
            $roleModel = Role::firstOrCreate(['name' => $role]);
            $roleModel->syncPermissions($rolePermissions);
        }
    }
}
