<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('report_dispatch_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('alert_rule_id')->constrained('alert_rules')->cascadeOnDelete();
            $table->timestamp('ran_at');
            $table->string('status');
            $table->unsignedInteger('recipient_count')->default(0);
            $table->unsignedInteger('case_count')->default(0);
            $table->boolean('is_manual')->default(false);
            $table->text('note')->nullable();
            $table->timestamps();

            $table->index(['alert_rule_id', 'ran_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('report_dispatch_logs');
    }
};
