<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CaseReportAlertMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $subjectLine,
        public string $bodyText
    ) {}

    public function build(): self
    {
        return $this->subject($this->subjectLine)
            ->view('emails.case-report-alert')
            ->with([
                'bodyText' => $this->bodyText,
            ]);
    }
}
