<?php

namespace App\Http\Controllers;

use App\Models\CaseComment;
use App\Models\CaseItem;
use Illuminate\Http\Request;

class CaseCommentController extends Controller
{
    public function store(Request $request, CaseItem $case)
    {
        $this->authorize('update', $case);

        $data = $request->validate([
            'body' => ['required', 'string'],
            'is_internal' => ['nullable', 'boolean'],
        ]);

        $comment = new CaseComment();
        $comment->case_id = $case->id;
        $comment->user_id = $request->user()->id;
        $comment->body = $data['body'];
        $comment->is_internal = (bool) ($data['is_internal'] ?? true);
        $comment->save();

        return redirect()->route('cases.show', $case)->with('status', 'Comment added.');
    }
}
