<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Users</h2>
            <a href="<?php echo e(route('admin.users.create')); ?>" class="btn-primary">New User</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <form method="POST" action="<?php echo e(route('admin.users.bulk-destroy')); ?>" onsubmit="return confirm('Delete selected users?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="mb-3 flex justify-end">
                    <button class="inline-flex items-center px-3 py-2 text-sm rounded-md bg-rose-50 text-rose-700 hover:bg-rose-100 transition">Delete Selected</button>
                </div>
                <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left"><input id="selectAllUsers" type="checkbox" class="rounded"></th>
                            <th class="px-4 py-3 text-left">Name</th>
                            <th class="px-4 py-3 text-left">Email</th>
                            <th class="px-4 py-3 text-left">Role</th>
                            <th class="px-4 py-3 text-left">Client</th>
                            <th class="px-4 py-3 text-left">Active</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-t">
                                <td class="px-4 py-3"><input type="checkbox" name="ids[]" value="<?php echo e($user->id); ?>" class="user-checkbox rounded"></td>
                                <td class="px-4 py-3"><?php echo e($user->name); ?></td>
                                <td class="px-4 py-3"><?php echo e($user->email); ?></td>
                                <td class="px-4 py-3"><?php echo e($user->roles->first()?->name ?? '—'); ?></td>
                                <td class="px-4 py-3"><?php echo e($user->client->name ?? '—'); ?></td>
                                <td class="px-4 py-3"><?php echo e($user->is_active ? 'Yes' : 'No'); ?></td>
                                <td class="px-4 py-3 text-right">
                                    <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    <form method="POST" action="<?php echo e(route('admin.users.destroy', $user)); ?>" class="inline" onsubmit="return confirm('Delete this user?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-4 py-6 text-center text-gray-500">No users found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                </div>
            </form>
            <div class="mt-4"><?php echo e($users->links()); ?></div>
        </div>
    </div>
    <?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const selectAll = document.getElementById('selectAllUsers');
            const checkboxes = document.querySelectorAll('.user-checkbox');
            if (!selectAll) return;
            selectAll.addEventListener('change', () => {
                checkboxes.forEach((cb) => cb.checked = selectAll.checked);
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/admin/users/index.blade.php ENDPATH**/ ?>