<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
</head>
<body style="font-family: Arial, sans-serif; color: #111827; line-height: 1.5;">
    <h2 style="margin-bottom: 4px;">Automated Case Report</h2>
    <p style="margin-top:0; color:#6b7280;">Rule: <?php echo e($rule->name); ?> | Scope: <?php echo e($rule->is_global ? 'Global' : 'Client'); ?></p>

    <?php $__currentLoopData = ($blocks ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($block === 'custom_message' && !empty($renderedBody)): ?>
            <h3>Message</h3>
            <div style="margin: 10px 0 18px; padding: 12px; background: #f8fafc; border: 1px solid #e5e7eb; border-radius: 6px;">
                <?php echo nl2br(e($renderedBody)); ?>

            </div>
        <?php endif; ?>

        <?php if($block === 'client_info'): ?>
            <h3>Client Info</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Field</th><th align="left">Value</th></tr>
                <tr><td>Client</td><td><?php echo e($clientInfo['name'] ?? 'N/A'); ?></td></tr>
                <tr><td>Scope</td><td><?php echo e($clientInfo['scope'] ?? 'N/A'); ?></td></tr>
                <tr><td>Timezone</td><td><?php echo e($clientInfo['timezone'] ?? 'N/A'); ?></td></tr>
                <tr><td>Date Range</td><td><?php echo e($clientInfo['date_from'] ?? 'N/A'); ?> to <?php echo e($clientInfo['date_to'] ?? 'N/A'); ?></td></tr>
                <tr><td>Default Notification Emails</td><td><?php echo e(implode(', ', $clientInfo['default_notification_emails'] ?? []) ?: 'N/A'); ?></td></tr>
            </table>
        <?php endif; ?>

        <?php if($block === 'summary_kpis'): ?>
            <h3>Summary</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:16px 0; border-color:#e5e7eb; font-size:14px;">
                <tr><th align="left">Metric</th><th align="left">Value</th></tr>
                <tr><td>Total Cases</td><td><?php echo e($summary['total']); ?></td></tr>
                <tr><td>Open</td><td><?php echo e($summary['open']); ?></td></tr>
                <tr><td>In Progress</td><td><?php echo e($summary['in_progress']); ?></td></tr>
                <tr><td>Waiting for User</td><td><?php echo e($summary['waiting']); ?></td></tr>
                <tr><td>Resolved</td><td><?php echo e($summary['resolved']); ?></td></tr>
                <tr><td>Closed</td><td><?php echo e($summary['closed']); ?></td></tr>
                <tr><td>Critical (not closed)</td><td><?php echo e($summary['critical']); ?></td></tr>
            </table>
        <?php endif; ?>

        <?php if($block === 'status_breakdown'): ?>
            <h3>Status Breakdown</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Status</th><th align="left">Count</th></tr>
                <?php $__empty_1 = true; $__currentLoopData = $statusBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr><td><?php echo e($k); ?></td><td><?php echo e($v); ?></td></tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="2">No data.</td></tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>

        <?php if($block === 'sentiment_breakdown'): ?>
            <h3>Sentiment Breakdown</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr><th align="left">Sentiment</th><th align="left">Count</th></tr>
                <?php $__empty_1 = true; $__currentLoopData = $sentimentBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr><td><?php echo e($k); ?></td><td><?php echo e($v); ?></td></tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="2">No data.</td></tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>

        <?php if($block === 'open_cases_table'): ?>
            <h3>Open / Active Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Sentiment</th><th align="left">Status</th><th align="left">Updated</th><th align="left">Link</th>
                </tr>
                <?php $__empty_1 = true; $__currentLoopData = $openCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>#<?php echo e($case['id']); ?></td><td><?php echo e($case['client']); ?></td><td><?php echo e($case['label']); ?></td><td><?php echo e($case['sentiment']); ?></td><td><?php echo e($case['status']); ?></td><td><?php echo e($case['updated_at']); ?></td><td><a href="<?php echo e($case['url']); ?>">Open Case</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="7">No open cases.</td></tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>

        <?php if($block === 'closed_cases_table'): ?>
            <h3>Closed Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Sentiment</th><th align="left">Closed At</th>
                </tr>
                <?php $__empty_1 = true; $__currentLoopData = $closedCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>#<?php echo e($case['id']); ?></td><td><?php echo e($case['client']); ?></td><td><?php echo e($case['label']); ?></td><td><?php echo e($case['sentiment']); ?></td><td><?php echo e($case['closed_at']); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="5">No closed cases.</td></tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>

        <?php if($block === 'critical_cases_table'): ?>
            <h3>Critical Cases</h3>
            <table cellpadding="8" cellspacing="0" border="1" style="border-collapse:collapse; width:100%; margin:12px 0; border-color:#e5e7eb; font-size:13px;">
                <tr>
                    <th align="left">ID</th><th align="left">Client</th><th align="left">Label</th><th align="left">Status</th><th align="left">Updated</th><th align="left">Link</th>
                </tr>
                <?php $__empty_1 = true; $__currentLoopData = $criticalCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>#<?php echo e($case['id']); ?></td><td><?php echo e($case['client']); ?></td><td><?php echo e($case['label']); ?></td><td><?php echo e($case['status']); ?></td><td><?php echo e($case['updated_at']); ?></td><td><a href="<?php echo e($case['url']); ?>">Open Case</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="6">No critical cases.</td></tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/emails/case-report-summary.blade.php ENDPATH**/ ?>