<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">Report Rules</h2>
                <div class="text-sm text-gray-500">Server Time: <?php echo e($serverTime->toDayDateTimeString()); ?></div>
            </div>
            <a href="<?php echo e(route('admin.report-rules.create')); ?>" class="btn-primary">New Rule</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left">Name</th>
                            <th class="px-4 py-3 text-left">Scope</th>
                            <th class="px-4 py-3 text-left">Trigger</th>
                            <th class="px-4 py-3 text-left">Schedule</th>
                            <th class="px-4 py-3 text-left">Last Result</th>
                            <th class="px-4 py-3 text-left">Enabled</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $nextRun = $rule->last_run_at
                                    ? $rule->last_run_at->copy()->addMinutes($rule->check_every_minutes)
                                    : now()->addMinutes($rule->check_every_minutes);
                                $log = $rule->latestDispatchLog;
                            ?>
                            <tr class="border-t">
                                <td class="px-4 py-3"><?php echo e($rule->name); ?></td>
                                <td class="px-4 py-3"><?php echo e($rule->is_global ? 'Global' : ($rule->client->name ?? 'Client')); ?></td>
                                <td class="px-4 py-3">
                                    Status: <?php echo e(implode(', ', $rule->statuses ?? [])); ?>

                                    <?php if(!empty($rule->trigger_actions)): ?>
                                        <br><span class="text-xs text-gray-500">Action: <?php echo e(implode(', ', $rule->trigger_actions)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3">
                                    <div>Every <?php echo e($rule->check_every_minutes); ?> min</div>
                                    <div class="text-xs text-gray-500">Next: <?php echo e($nextRun->toDayDateTimeString()); ?></div>
                                </td>
                                <td class="px-4 py-3">
                                    <?php if($log): ?>
                                        <div class="text-sm <?php echo e($log->status === 'failed' ? 'text-rose-700' : 'text-gray-800'); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $log->status))); ?>

                                        </div>
                                        <div class="text-xs text-gray-500"><?php echo e(optional($log->ran_at)->toDayDateTimeString()); ?></div>
                                        <?php if(!empty($log->note)): ?>
                                            <div class="text-xs text-rose-600 mt-1"><?php echo e($log->note); ?></div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="text-sm text-gray-500">No run yet</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3"><?php echo e($rule->enabled ? 'Yes' : 'No'); ?></td>
                                <td class="px-4 py-3 text-right">
                                    <form method="POST" action="<?php echo e(route('admin.report-rules.run-now', $rule)); ?>" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button class="text-emerald-600 hover:underline">Run Now</button>
                                    </form>
                                    <a href="<?php echo e(route('admin.report-rules.edit', $rule)); ?>" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    <form method="POST" action="<?php echo e(route('admin.report-rules.destroy', $rule)); ?>" class="inline" onsubmit="return confirm('Delete this report rule?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="7" class="px-4 py-6 text-center text-gray-500">No report rules yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4"><?php echo e($rules->links()); ?></div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/admin/report-rules/index.blade.php ENDPATH**/ ?>