<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-brand-gradient lg:flex relative overflow-hidden">
            <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="flex-1 min-w-0">
                <?php if(isset($header)): ?>
                    <header class="px-4 sm:px-6 lg:px-8 pt-6">
                        <div class="card p-4 sm:p-5">
                            <?php echo e($header); ?>

                        </div>
                    </header>
                <?php endif; ?>

                <main>
                    <?php if(session('status')): ?>
                        <div class="max-w-7xl mx-auto mt-4 px-4 sm:px-6 lg:px-8">
                            <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded">
                                <?php echo e(session('status')); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                    <?php echo e($slot); ?>

                </main>
            </div>
        </div>
        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/layouts/app.blade.php ENDPATH**/ ?>