<?php
    $rule = $rule ?? null;
?>

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Rule Name</label>
        <input type="text" name="name" value="<?php echo e(old('name', $rule->name ?? '')); ?>" class="mt-1 w-full border-gray-300 rounded-md" required>
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">Enabled</label>
        <select name="enabled" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" <?php if((int) old('enabled', $rule->enabled ?? 1) === 1): echo 'selected'; endif; ?>>Yes</option>
            <option value="0" <?php if((int) old('enabled', $rule->enabled ?? 1) === 0): echo 'selected'; endif; ?>>No</option>
        </select>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Scope</label>
        <select id="scopeSelect" name="is_global" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" <?php if((int) old('is_global', $rule->is_global ?? 1) === 1): echo 'selected'; endif; ?>>Global (all clients)</option>
            <option value="0" <?php if((int) old('is_global', $rule->is_global ?? 1) === 0): echo 'selected'; endif; ?>>Per Client</option>
        </select>
    </div>
    <div id="clientSelectWrap">
        <label class="block text-sm font-medium text-gray-700">Client</label>
        <select name="client_id" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="">Select client</option>
            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($client->id); ?>" <?php if((int) old('client_id', $rule->client_id ?? 0) === (int) $client->id): echo 'selected'; endif; ?>><?php echo e($client->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Schedule Mode</label>
        <select id="scheduleMode" name="schedule_mode" class="mt-1 w-full border-gray-300 rounded-md" required>
            <option value="interval" <?php if(old('schedule_mode', $rule->schedule_mode ?? 'interval') === 'interval'): echo 'selected'; endif; ?>>Interval Only</option>
            <option value="weekly" <?php if(old('schedule_mode', $rule->schedule_mode ?? 'interval') === 'weekly'): echo 'selected'; endif; ?>>Days & Times Only</option>
            <option value="both" <?php if(old('schedule_mode', $rule->schedule_mode ?? 'interval') === 'both'): echo 'selected'; endif; ?>>Interval + Days/Times</option>
        </select>
        <div class="text-xs text-gray-500 mt-1">Choose how the report is scheduled.</div>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Check Interval (minutes)</label>
        <input id="checkIntervalInput" type="number" min="5" name="check_every_minutes" value="<?php echo e(old('check_every_minutes', $rule->check_every_minutes ?? 60)); ?>" class="mt-1 w-full border-gray-300 rounded-md" required>
        <div id="nextRunHint" class="text-xs text-blue-700 mt-1">Expected next run: —</div>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Re-notify Every (hours)</label>
        <input type="number" min="1" name="renotify_every_hours" value="<?php echo e(old('renotify_every_hours', optional($rule)->renotify_every_hours)); ?>" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">CC Client Default Emails</label>
        <select name="cc_client" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" <?php if((int) old('cc_client', $rule->cc_client ?? 0) === 1): echo 'selected'; endif; ?>>Yes</option>
            <option value="0" <?php if((int) old('cc_client', $rule->cc_client ?? 0) === 0): echo 'selected'; endif; ?>>No</option>
        </select>
    </div>
</div>

<div id="weeklyScheduleWrap" class="mt-4">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700">Send Days (optional)</label>
            <?php $selectedDays = old('send_days', $rule->send_days ?? []); ?>
            <div class="mt-2 grid grid-cols-4 gap-2">
                <?php $__currentLoopData = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="text-sm inline-flex items-center gap-2">
                        <input type="checkbox" name="send_days[]" value="<?php echo e($day); ?>" <?php if(in_array($day, $selectedDays, true)): echo 'checked'; endif; ?>>
                        <span><?php echo e($day); ?></span>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php $__errorArgs = ['send_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-sm text-rose-600 mt-1"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Send Times (HH:MM, 5-min steps)</label>
            <?php $selectedTimes = old('send_times', $rule->send_times ?? []); ?>
            <div class="mt-2 flex items-center gap-2">
                <input id="timeAddInput" type="time" step="300" class="w-full border-gray-300 rounded-md">
                <button id="addTimeBtn" type="button" class="btn-outline">Add</button>
            </div>
            <div id="timeChips" class="mt-2 flex flex-wrap gap-2"></div>
            <?php $__errorArgs = ['send_times'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-sm text-rose-600 mt-1"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
</div>

<div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Track Cases From Date (optional)</label>
        <input type="date" name="track_date_from" value="<?php echo e(old('track_date_from', optional($rule)->track_date_from?->format('Y-m-d'))); ?>" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">Track Cases To Date (optional)</label>
        <input type="date" name="track_date_to" value="<?php echo e(old('track_date_to', optional($rule)->track_date_to?->format('Y-m-d'))); ?>" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Statuses that trigger this report</label>
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        <?php $selectedStatuses = old('statuses', $rule->statuses ?? ['Open', 'In Progress', 'Waiting for User']); ?>
        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="statuses[]" value="<?php echo e($status); ?>" <?php if(in_array($status, $selectedStatuses, true)): echo 'checked'; endif; ?>>
                <span><?php echo e($status); ?></span>
            </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Action Triggers (optional)</label>
    <?php $selectedActions = old('trigger_actions', $rule->trigger_actions ?? []); ?>
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="trigger_actions[]" value="<?php echo e($action); ?>" <?php if(in_array($action, $selectedActions, true)): echo 'checked'; endif; ?>>
                <span><?php echo e($action); ?></span>
            </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="text-xs text-gray-500 mt-1">If selected, only cases with matching Action (Social Media Team) are included.</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Recipients by Role</label>
    <?php $selectedRoles = old('recipients_roles', $rule->recipients_roles ?? []); ?>
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="recipients_roles[]" value="<?php echo e($role); ?>" <?php if(in_array($role, $selectedRoles, true)): echo 'checked'; endif; ?>>
                <span><?php echo e($role); ?></span>
            </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Recipient Emails (search and add)</label>
    <?php $selectedEmails = old('recipients_emails_selected', $rule->recipients_emails ?? []); ?>
    <input id="emailSearchInput" type="text" class="mt-1 w-full border-gray-300 rounded-md" placeholder="Type email and press Enter">
    <datalist id="emailSuggestions">
        <?php $__currentLoopData = $emailOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($email); ?>"></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </datalist>
    <div id="emailChips" class="mt-2 flex flex-wrap gap-2"></div>
    <div class="text-xs text-gray-500 mt-1">Press Enter to add. Click × to remove.</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Additional Recipient Emails (comma-separated)</label>
    <input type="text" name="recipients_emails" value="<?php echo e(old('recipients_emails', isset($rule) ? implode(',', $rule->recipients_emails ?? []) : '')); ?>" class="mt-1 w-full border-gray-300 rounded-md">
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Email Subject</label>
    <input type="text" name="email_subject" value="<?php echo e(old('email_subject', $rule->email_subject ?? 'Case Escalation Alert - {case_id}')); ?>" class="mt-1 w-full border-gray-300 rounded-md" required>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Email Body Template</label>
    <textarea name="email_body" rows="8" class="mt-1 w-full border-gray-300 rounded-md" required><?php echo e(old('email_body', $rule->email_body ?? "Hello Team,\n\nHere is the automated case report.\nRule: {rule_name}\nScope: {scope}\nClient: {client_name}\nDate Range: {from_date} to {to_date}\nGenerated At: {generated_at}\n\nTotals\n- Total Cases: {total_cases}\n- Open Cases: {open_cases}\n- Closed Cases: {closed_cases}\n- Critical Cases: {critical_cases}")); ?></textarea>
    <div class="text-xs text-gray-500 mt-1">Variables: {rule_name}, {scope}, {client_name}, {from_date}, {to_date}, {total_cases}, {open_cases}, {closed_cases}, {critical_cases}, {generated_at}</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Report Content Blocks (drag to reorder)</label>
    <?php
        $selectedBlocks = old('report_blocks_json')
            ? (json_decode(old('report_blocks_json'), true) ?: [])
            : ($rule->report_blocks ?? ['custom_message', 'summary_kpis', 'open_cases_table', 'closed_cases_table']);
    ?>
    <input type="hidden" id="reportBlocksJson" name="report_blocks_json" value="<?php echo e(old('report_blocks_json', json_encode($selectedBlocks))); ?>">
    <div class="mt-2 grid grid-cols-1 lg:grid-cols-2 gap-4">
        <div class="rounded-lg border border-gray-200 p-3">
            <div class="text-xs text-gray-500 mb-2">Selected Blocks</div>
            <ul id="selectedBlocksList" class="space-y-2"></ul>
        </div>
        <div class="rounded-lg border border-gray-200 p-3">
            <div class="text-xs text-gray-500 mb-2">Available Blocks</div>
            <ul id="availableBlocksList" class="space-y-2"></ul>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const scope = document.getElementById('scopeSelect');
        const wrap = document.getElementById('clientSelectWrap');
        if (!scope || !wrap) return;
        const sync = () => wrap.style.display = scope.value === '1' ? 'none' : 'block';
        sync();
        scope.addEventListener('change', sync);

        const scheduleMode = document.getElementById('scheduleMode');
        const weeklyWrap = document.getElementById('weeklyScheduleWrap');
        const syncSchedule = () => {
            if (!scheduleMode || !weeklyWrap) return;
            const mode = scheduleMode.value;
            weeklyWrap.style.display = (mode === 'weekly' || mode === 'both') ? 'block' : 'none';
        };
        if (scheduleMode && weeklyWrap) {
            syncSchedule();
            scheduleMode.addEventListener('change', syncSchedule);
        }

        const searchInput = document.getElementById('emailSearchInput');
        const chipsWrap = document.getElementById('emailChips');
        const initial = <?php echo json_encode(array_values(array_unique($selectedEmails)), 15, 512) ?>;
        if (!searchInput || !chipsWrap) return;

        searchInput.setAttribute('list', 'emailSuggestions');
        const selected = new Set(initial);

        const validateEmail = (value) => /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);

        const render = () => {
            chipsWrap.innerHTML = '';
            selected.forEach((email) => {
                const chip = document.createElement('span');
                chip.className = 'inline-flex items-center gap-2 px-2 py-1 rounded-full text-xs bg-blue-50 text-blue-700';
                chip.textContent = email;

                const btn = document.createElement('button');
                btn.type = 'button';
                btn.className = 'text-blue-900';
                btn.textContent = '×';
                btn.addEventListener('click', () => {
                    selected.delete(email);
                    render();
                });

                const hidden = document.createElement('input');
                hidden.type = 'hidden';
                hidden.name = 'recipients_emails_selected[]';
                hidden.value = email;

                chip.appendChild(btn);
                chipsWrap.appendChild(chip);
                chipsWrap.appendChild(hidden);
            });
        };

        searchInput.addEventListener('keydown', (e) => {
            if (e.key !== 'Enter') return;
            e.preventDefault();
            const value = searchInput.value.trim();
            if (!value || !validateEmail(value)) return;
            selected.add(value);
            searchInput.value = '';
            render();
        });

        render();

        const timeInput = document.getElementById('timeAddInput');
        const timeBtn = document.getElementById('addTimeBtn');
        const timeWrap = document.getElementById('timeChips');
        const initialTimes = <?php echo json_encode(array_values(array_unique($selectedTimes)), 15, 512) ?>;

        if (timeInput && timeBtn && timeWrap) {
            const times = new Set(initialTimes);

            const renderTimes = () => {
                timeWrap.innerHTML = '';
                Array.from(times).sort().forEach((time) => {
                    const chip = document.createElement('span');
                    chip.className = 'inline-flex items-center gap-2 px-2 py-1 rounded-full text-xs bg-blue-50 text-blue-700';
                    chip.textContent = time;

                    const btn = document.createElement('button');
                    btn.type = 'button';
                    btn.className = 'text-blue-900';
                    btn.textContent = '×';
                    btn.addEventListener('click', () => {
                        times.delete(time);
                        renderTimes();
                    });

                    const hidden = document.createElement('input');
                    hidden.type = 'hidden';
                    hidden.name = 'send_times[]';
                    hidden.value = time;

                    chip.appendChild(btn);
                    timeWrap.appendChild(chip);
                    timeWrap.appendChild(hidden);
                });
            };

            const addTime = () => {
                const value = timeInput.value;
                if (!value) return;
                times.add(value);
                timeInput.value = '';
                renderTimes();
            };

            timeBtn.addEventListener('click', addTime);
            timeInput.addEventListener('keydown', (e) => {
                if (e.key !== 'Enter') return;
                e.preventDefault();
                addTime();
            });

            renderTimes();
        }

        const blockMap = <?php echo json_encode($blockOptions, 15, 512) ?>;
        const selectedInput = document.getElementById('reportBlocksJson');
        const selectedList = document.getElementById('selectedBlocksList');
        const availableList = document.getElementById('availableBlocksList');
        if (!selectedInput || !selectedList || !availableList) return;

        let selectedBlocks = [];
        try {
            selectedBlocks = JSON.parse(selectedInput.value || '[]');
        } catch (e) {
            selectedBlocks = [];
        }
        if (!Array.isArray(selectedBlocks) || selectedBlocks.length === 0) {
            selectedBlocks = ['custom_message', 'summary_kpis', 'open_cases_table', 'closed_cases_table'];
        }

        const allKeys = Object.keys(blockMap);

        const updateHidden = () => {
            selectedInput.value = JSON.stringify(selectedBlocks);
        };

        const makeItem = (key, isSelected) => {
            const li = document.createElement('li');
            li.className = 'flex items-center justify-between gap-2 px-3 py-2 rounded-md border text-sm bg-white';
            li.draggable = isSelected;
            li.dataset.key = key;
            li.innerHTML = `<span>${blockMap[key] ?? key}</span>`;

            const btn = document.createElement('button');
            btn.type = 'button';
            btn.className = 'text-xs px-2 py-1 rounded bg-blue-50 text-blue-700';
            btn.textContent = isSelected ? 'Remove' : 'Add';
            btn.addEventListener('click', () => {
                if (isSelected) {
                    selectedBlocks = selectedBlocks.filter(v => v !== key);
                } else if (!selectedBlocks.includes(key)) {
                    selectedBlocks.push(key);
                }
                renderBlocks();
            });
            li.appendChild(btn);

            if (isSelected) {
                li.addEventListener('dragstart', (e) => {
                    e.dataTransfer.setData('text/plain', key);
                });
            }

            return li;
        };

        selectedList.addEventListener('dragover', (e) => e.preventDefault());
        selectedList.addEventListener('drop', (e) => {
            e.preventDefault();
            const draggedKey = e.dataTransfer.getData('text/plain');
            const targetLi = e.target.closest('li');
            if (!draggedKey || !targetLi) return;
            const targetKey = targetLi.dataset.key;
            if (!selectedBlocks.includes(draggedKey) || !selectedBlocks.includes(targetKey)) return;
            selectedBlocks = selectedBlocks.filter(v => v !== draggedKey);
            const targetIndex = selectedBlocks.indexOf(targetKey);
            selectedBlocks.splice(targetIndex, 0, draggedKey);
            renderBlocks();
        });

        const renderBlocks = () => {
            selectedList.innerHTML = '';
            availableList.innerHTML = '';
            selectedBlocks.forEach((key) => selectedList.appendChild(makeItem(key, true)));
            allKeys.filter(k => !selectedBlocks.includes(k)).forEach((key) => availableList.appendChild(makeItem(key, false)));
            updateHidden();
        };

        renderBlocks();

        const intervalInput = document.getElementById('checkIntervalInput');
        const nextRunHint = document.getElementById('nextRunHint');
        const lastRunAt = <?php echo json_encode(optional($rule)->last_run_at?->toIso8601String(), 15, 512) ?>;

        const computeHint = () => {
            if (!intervalInput || !nextRunHint) return;
            const mins = parseInt(intervalInput.value || '0', 10);
            if (!mins || mins < 1) {
                nextRunHint.textContent = 'Expected next run: invalid interval';
                return;
            }

            const base = lastRunAt ? new Date(lastRunAt) : new Date();
            const next = new Date(base.getTime() + mins * 60000);
            const hrs = (mins / 60).toFixed(mins % 60 === 0 ? 0 : 1);
            nextRunHint.textContent = `Expected next run: every ${mins} min (~${hrs}h). Next around ${next.toLocaleString()}`;
        };

        if (intervalInput) intervalInput.addEventListener('input', computeHint);
        computeHint();
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/admin/report-rules/_form.blade.php ENDPATH**/ ?>