<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin Dashboard</h2>
            <div class="text-sm text-gray-500">Global overview</div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Total Clients</div>
                    <div class="text-2xl font-semibold"><?php echo e($kpis['clients']); ?></div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Total Cases</div>
                    <div class="text-2xl font-semibold"><?php echo e($kpis['total_cases']); ?></div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Overdue (><?php echo e($charts['sla_threshold_hours']); ?>h)</div>
                    <div class="text-2xl font-semibold text-rose-600"><?php echo e($kpis['overdue_cases']); ?></div>
                </div>
                <div class="card p-5">
                    <div class="text-sm text-gray-500">Critical Open</div>
                    <div class="text-2xl font-semibold text-amber-600"><?php echo e($kpis['critical_cases']); ?></div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
                <a href="<?php echo e(route('admin.users.index')); ?>" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Manage Users</div>
                    <div class="text-lg font-semibold text-gray-800">Users & Roles</div>
                </a>
                <a href="<?php echo e(route('admin.clients.index')); ?>" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Manage Clients</div>
                    <div class="text-lg font-semibold text-gray-800">Clients & Labels</div>
                </a>
                <a href="<?php echo e(route('admin.assignments.index')); ?>" class="card p-5 hover:shadow-md transition">
                    <div class="text-sm text-gray-500">Assignments</div>
                    <div class="text-lg font-semibold text-gray-800">User ↔ Client</div>
                </a>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-6">
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Cases Trend (14 days)</div>
                    <div class="chart-wrap">
                        <canvas id="trendChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Sentiment Distribution</div>
                    <div class="chart-wrap">
                        <canvas id="sentimentChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Top Labels</div>
                    <div class="chart-wrap">
                        <canvas id="labelsChart"></canvas>
                    </div>
                </div>
                <div class="card p-6">
                    <div class="text-sm font-semibold text-gray-700 mb-3">Sources Mix</div>
                    <div class="chart-wrap">
                        <canvas id="sourcesChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="card p-6 mt-6">
                <div class="flex flex-wrap items-center justify-between gap-3 mb-4">
                    <div>
                        <div class="text-sm font-semibold text-gray-700">Scheduler Status</div>
                        <div class="text-xs text-gray-500">Server time and scheduled tasks</div>
                    </div>
                    <div class="text-sm text-gray-600">
                        <span class="font-semibold">Server Time:</span>
                        <span class="ml-1"><?php echo e($serverTime->format('Y-m-d H:i:s')); ?></span>
                        <span class="ml-2 text-gray-500">(<?php echo e(config('app.timezone')); ?>)</span>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="rounded-lg border border-slate-200/80 bg-slate-50 p-4">
                        <div class="text-sm font-semibold text-gray-700">Scheduled Task</div>
                        <div class="text-sm text-gray-600 mt-1"><span class="font-mono">reports:send-alerts</span></div>
                        <div class="text-xs text-gray-500 mt-1">Runs every 5 minutes via Laravel scheduler</div>
                        <div class="text-xs text-gray-600 mt-2">
                            <span class="font-semibold">Next Run:</span>
                            <span class="ml-1"><?php echo e($nextSchedulerRun->format('Y-m-d H:i:s')); ?></span>
                        </div>
                    </div>
                    <div class="rounded-lg border border-slate-200/80 bg-white p-4">
                        <div class="text-sm font-semibold text-gray-700">Rule Schedule Preview</div>
                        <div class="text-xs text-gray-500 mt-1">Based on each rule interval</div>
                        <div class="mt-3 overflow-x-auto">
                            <table class="min-w-full text-xs">
                                <thead class="text-gray-500">
                                    <tr>
                                        <th class="px-2 py-1 text-left">Rule</th>
                                        <th class="px-2 py-1 text-left">Scope</th>
                                        <th class="px-2 py-1 text-left">Interval</th>
                                        <th class="px-2 py-1 text-left">Last Run</th>
                                        <th class="px-2 py-1 text-left">Next Run</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $ruleSchedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="border-t">
                                            <td class="px-2 py-1"><?php echo e($rule['name']); ?></td>
                                            <td class="px-2 py-1"><?php echo e($rule['client']); ?></td>
                                            <td class="px-2 py-1"><?php echo e($rule['interval']); ?> min</td>
                                            <td class="px-2 py-1"><?php echo e($rule['last_run_at']?->format('Y-m-d H:i') ?? '—'); ?></td>
                                            <td class="px-2 py-1"><?php echo e($rule['next_run_at']?->format('Y-m-d H:i') ?? '—'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr><td colspan="5" class="px-2 py-2 text-gray-500">No enabled rules.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card p-6 mt-6">
                <div class="flex items-center justify-between mb-3">
                    <div class="text-sm font-semibold text-gray-700">Automatic Report Logs</div>
                    <a href="<?php echo e(route('admin.report-rules.index')); ?>" class="text-sm text-[color:var(--brand-primary)] hover:underline">Manage Rules</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="text-gray-500">
                            <tr>
                                <th class="px-3 py-2 text-left">Time</th>
                                <th class="px-3 py-2 text-left">Rule</th>
                                <th class="px-3 py-2 text-left">Status</th>
                                <th class="px-3 py-2 text-left">Recipients</th>
                                <th class="px-3 py-2 text-left">Cases</th>
                                <th class="px-3 py-2 text-left">Manual</th>
                                <th class="px-3 py-2"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $reportLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t">
                                    <td class="px-3 py-2"><?php echo e($log->ran_at); ?></td>
                                    <td class="px-3 py-2"><?php echo e($log->rule->name ?? '-'); ?></td>
                                    <td class="px-3 py-2"><?php echo e($log->status); ?></td>
                                    <td class="px-3 py-2"><?php echo e($log->recipient_count); ?></td>
                                    <td class="px-3 py-2"><?php echo e($log->case_count); ?></td>
                                    <td class="px-3 py-2"><?php echo e($log->is_manual ? 'Yes' : 'No'); ?></td>
                                    <td class="px-3 py-2 text-right">
                                        <?php if($log->rule): ?>
                                            <form method="POST" action="<?php echo e(route('admin.report-rules.run-now', $log->rule)); ?>" class="inline">
                                                <?php echo csrf_field(); ?>
                                                <button class="text-emerald-600 hover:underline">Run Again</button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="7" class="px-3 py-3 text-gray-500">No report runs yet.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
            const trendLabels = <?php echo json_encode($charts['trend_labels'], 15, 512) ?>;
            const trendCounts = <?php echo json_encode($charts['trend_counts'], 15, 512) ?>;
            const sentimentLabels = <?php echo json_encode($charts['sentiment_labels'], 15, 512) ?>;
            const sentimentCounts = <?php echo json_encode($charts['sentiment_counts'], 15, 512) ?>;
            const labelLabels = <?php echo json_encode($charts['label_labels'], 15, 512) ?>;
            const labelCounts = <?php echo json_encode($charts['label_counts'], 15, 512) ?>;
            const sourceLabels = <?php echo json_encode($charts['source_labels'], 15, 512) ?>;
            const sourceCounts = <?php echo json_encode($charts['source_counts'], 15, 512) ?>;

            if (!window.Chart) return;
            const getVar = (name, fallback) => getComputedStyle(document.documentElement).getPropertyValue(name).trim() || fallback;
            const primary = getVar('--brand-primary', '#1e3a8a');
            const accent = getVar('--brand-accent', '#38bdf8');

            new Chart(document.getElementById('trendChart'), {
                type: 'line',
                data: {
                    labels: trendLabels,
                    datasets: [{
                        label: 'Cases',
                        data: trendCounts,
                        borderColor: primary,
                        backgroundColor: 'rgba(56,189,248,0.2)',
                        tension: 0.3,
                        fill: true,
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('sentimentChart'), {
                type: 'doughnut',
                data: {
                    labels: sentimentLabels,
                    datasets: [{
                        data: sentimentCounts,
                        backgroundColor: ['#22c55e', '#94a3b8', '#ef4444', '#b91c1c'],
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('labelsChart'), {
                type: 'bar',
                data: {
                    labels: labelLabels,
                    datasets: [{
                        label: 'Cases',
                        data: labelCounts,
                        backgroundColor: accent
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });

            new Chart(document.getElementById('sourcesChart'), {
                type: 'bar',
                data: {
                    labels: sourceLabels,
                    datasets: [{
                        label: 'Cases',
                        data: sourceCounts,
                        backgroundColor: primary
                    }]
                },
                options: { responsive: true, maintainAspectRatio: false }
            });
            });
        </script>
        <style>
            #trendChart, #sentimentChart, #labelsChart, #sourcesChart { height: 280px; }
        </style>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\community-t\resources\views/dashboards/admin.blade.php ENDPATH**/ ?>