<?php

use App\Http\Controllers\CaseCommentController;
use App\Http\Controllers\CaseController;
use App\Http\Controllers\CaseExportController;
use App\Http\Controllers\CaseOwnerController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\AssignmentController;
use App\Http\Controllers\Admin\ClientController;
use App\Http\Controllers\Admin\LabelController;
use App\Http\Controllers\Admin\ReportRuleController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\UserController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/contact-us', [ContactController::class, 'create'])->name('contact.create');
Route::post('/contact-us', [ContactController::class, 'store'])->name('contact.store');

Route::get('/dashboard', DashboardController::class)
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/cases', [CaseController::class, 'index'])->name('cases.index');
    Route::delete('/cases/bulk-delete', [CaseController::class, 'bulkDestroy'])->name('cases.bulk-destroy');
    Route::get('/cases/create', [CaseController::class, 'create'])->name('cases.create');
    Route::post('/cases', [CaseController::class, 'store'])->name('cases.store');
    Route::get('/cases/export', CaseExportController::class)->name('cases.export');
    Route::get('/cases/{case}', [CaseController::class, 'show'])->name('cases.show');
    Route::get('/cases/{case}/edit', [CaseController::class, 'edit'])->name('cases.edit');
    Route::put('/cases/{case}', [CaseController::class, 'update'])->name('cases.update');
    Route::delete('/cases/{case}', [CaseController::class, 'destroy'])->name('cases.destroy');
    Route::post('/cases/{case}/comments', [CaseCommentController::class, 'store'])->name('cases.comments.store');
    Route::post('/cases/{case}/owners', [CaseOwnerController::class, 'update'])->name('cases.owners.update');

    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/', function () {
            return view('admin.home');
        })->name('home');

        Route::resource('clients', ClientController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);
        Route::delete('clients/bulk-delete', [ClientController::class, 'bulkDestroy'])->name('clients.bulk-destroy');
        Route::resource('users', UserController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);
        Route::delete('users/bulk-delete', [UserController::class, 'bulkDestroy'])->name('users.bulk-destroy');
        Route::resource('roles', RoleController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);
        Route::resource('labels', LabelController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);
        Route::delete('labels/bulk-delete', [LabelController::class, 'bulkDestroy'])->name('labels.bulk-destroy');
        Route::resource('report-rules', ReportRuleController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);
        Route::post('report-rules/{report_rule}/run-now', [ReportRuleController::class, 'runNow'])->name('report-rules.run-now');
        Route::get('assignments', [AssignmentController::class, 'index'])->name('assignments.index');
        Route::post('assignments', [AssignmentController::class, 'update'])->name('assignments.update');
        Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');
        Route::put('settings', [SettingsController::class, 'update'])->name('settings.update');
    });
});

require __DIR__.'/auth.php';
