<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-brand-gradient lg:flex relative overflow-hidden">
            @include('layouts.navigation')

            <div class="flex-1 min-w-0">
                @isset($header)
                    <header class="px-4 sm:px-6 lg:px-8 pt-6">
                        <div class="card p-4 sm:p-5">
                            {{ $header }}
                        </div>
                    </header>
                @endisset

                <main>
                    @if (session('status'))
                        <div class="max-w-7xl mx-auto mt-4 px-4 sm:px-6 lg:px-8">
                            <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded">
                                {{ session('status') }}
                            </div>
                        </div>
                    @endif
                    {{ $slot }}
                </main>
            </div>
        </div>
        @stack('scripts')
    </body>
</html>
