<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin Settings</h2>
            <div class="text-sm text-gray-500">System configuration</div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="card p-6">
                <div class="text-sm font-semibold text-gray-700">Application Timezone</div>
                <div class="text-xs text-gray-500 mt-1">Default: Asia/Riyadh</div>

                @if (session('status'))
                    <div class="mt-4 text-sm text-emerald-600">{{ session('status') }}</div>
                @endif

                <form method="POST" action="{{ route('admin.settings.update') }}" class="mt-4">
                    @csrf
                    @method('PUT')

                    <label class="block text-sm text-gray-600" for="timezone">Select Timezone</label>
                    <select id="timezone" name="timezone" class="mt-1 w-full border-slate-200 rounded-lg" required>
                        @foreach($timezones as $tz)
                            <option value="{{ $tz }}" @selected($tz === $currentTimezone)>{{ $tz }}</option>
                        @endforeach
                    </select>
                    @error('timezone')
                        <div class="text-sm text-rose-600 mt-1">{{ $message }}</div>
                    @enderror

                    <div class="mt-4">
                        <button class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-sky-600 text-white hover:bg-sky-500 transition">Save Timezone</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
