<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Roles & Permissions</h2>
            <a href="{{ route('admin.roles.create') }}" class="btn-primary">New Role</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left">Role</th>
                            <th class="px-4 py-3 text-left">Permissions</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($roles as $role)
                            <tr class="border-t">
                                <td class="px-4 py-3 font-medium">{{ $role->name }}</td>
                                <td class="px-4 py-3">{{ $role->permissions_count }}</td>
                                <td class="px-4 py-3 text-right">
                                    <a href="{{ route('admin.roles.edit', $role) }}" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    @if($role->name !== 'Super Admin')
                                        <form method="POST" action="{{ route('admin.roles.destroy', $role) }}" class="inline" onsubmit="return confirm('Delete this role?');">
                                            @csrf
                                            @method('DELETE')
                                            <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="3" class="px-4 py-6 text-center text-gray-500">No roles found.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">{{ $roles->links() }}</div>
        </div>
    </div>
</x-app-layout>
