<div>
    <label class="block text-sm font-medium text-gray-700">Role Name</label>
    <input type="text" name="name" value="{{ old('name', $role->name ?? '') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
    @error('name')<div class="text-sm text-rose-600 mt-1">{{ $message }}</div>@enderror
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Permissions</label>
    @php $selected = old('permissions', isset($role) ? $role->permissions->pluck('name')->all() : []); @endphp
    <div class="mt-2 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2">
        @foreach($permissions as $permission)
            <label class="inline-flex items-center gap-2 text-sm">
                <input type="checkbox" name="permissions[]" value="{{ $permission->name }}" @checked(in_array($permission->name, $selected, true))>
                <span>{{ $permission->name }}</span>
            </label>
        @endforeach
    </div>
</div>
