<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Labels</h2>
            <a href="{{ route('admin.labels.create') }}" class="btn-primary">New Label</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <form method="POST" action="{{ route('admin.labels.bulk-destroy') }}" onsubmit="return confirm('Delete selected labels?');">
                @csrf
                @method('DELETE')
                <div class="mb-3 flex justify-end">
                    <button class="inline-flex items-center px-3 py-2 text-sm rounded-md bg-rose-50 text-rose-700 hover:bg-rose-100 transition">Delete Selected</button>
                </div>
                <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left"><input id="selectAllLabels" type="checkbox" class="rounded"></th>
                            <th class="px-4 py-3 text-left">Label</th>
                            <th class="px-4 py-3 text-left">Sort</th>
                            <th class="px-4 py-3 text-left">Active</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($labels as $label)
                            <tr class="border-t">
                                <td class="px-4 py-3"><input type="checkbox" name="ids[]" value="{{ $label->id }}" class="label-checkbox rounded"></td>
                                <td class="px-4 py-3">{{ $label->value }}</td>
                                <td class="px-4 py-3">{{ $label->sort_order }}</td>
                                <td class="px-4 py-3">{{ $label->is_active ? 'Yes' : 'No' }}</td>
                                <td class="px-4 py-3 text-right">
                                    <a href="{{ route('admin.labels.edit', $label) }}" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    <form method="POST" action="{{ route('admin.labels.destroy', $label) }}" class="inline" onsubmit="return confirm('Delete this label?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-4 py-6 text-center text-gray-500">No labels found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                </div>
            </form>
            <div class="mt-4">{{ $labels->links() }}</div>
        </div>
    </div>
    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const selectAll = document.getElementById('selectAllLabels');
            const checkboxes = document.querySelectorAll('.label-checkbox');
            if (!selectAll) return;
            selectAll.addEventListener('change', () => {
                checkboxes.forEach((cb) => cb.checked = selectAll.checked);
            });
        });
    </script>
    @endpush
</x-app-layout>
