<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Edit Label</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="card p-6">
                <form method="POST" action="{{ route('admin.labels.update', $label) }}">
                    @csrf
                    @method('PUT')
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Label</label>
                            <input type="text" name="value" value="{{ old('value', $label->value) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                            @error('value')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Sort Order</label>
                            <input type="number" name="sort_order" value="{{ old('sort_order', $label->sort_order) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Active</label>
                            <select name="is_active" class="mt-1 w-full border-gray-300 rounded-md">
                                <option value="1" @selected($label->is_active)>Yes</option>
                                <option value="0" @selected(!$label->is_active)>No</option>
                            </select>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-end gap-2">
                        <a href="{{ route('admin.labels.index') }}" class="btn-outline">Cancel</a>
                        <button class="btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
