<?php

namespace Database\Seeders;

use App\Models\CaseOption;
use Illuminate\Database\Seeder;

class DefaultCaseOptionsSeeder extends Seeder
{
    public function run(): void
    {
        $groups = [
            'label' => [
                'KA-Carrier Complaint',
                'KA-Complaints',
                'KA-Luggage',
                'KA-Delayed',
                'KA-Cancellation',
                'KA-General Inquiry',
                'KA-Ground Handler',
                'KA-Team Behavior',
                'KA-Facilities',
                'KA-Parking',
                'KA-Neutral-C',
                'KA-Positive-C',
                'KA-Negative-C',
                'ADS',
                'Job Inquiry',
                'Flight Suspension',
                'Spam',
            ],
            'source' => [
                'Social Listening (Indirect)',
                'Community Management (Direct Mentions)',
            ],
            'sentiment' => [
                'Positive',
                'Neutral',
                'Negative',
                'Critical',
            ],
            'action_social' => [
                'Pending Information',
                'Case Closed',
                'No Action - Crisis Related',
                'No Action - Partner Mentioned',
                'No Action - News',
                'No Action - General Recommendation/Opinion',
            ],
            'status' => [
                'Open',
                'In Progress',
                'Waiting for User',
                'Resolved',
                'Closed',
            ],
        ];

        foreach ($groups as $group => $values) {
            foreach ($values as $index => $value) {
                CaseOption::firstOrCreate(
                    ['group' => $group, 'value' => $value],
                    ['sort_order' => $index + 1]
                );
            }
        }
    }
}
