<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('alert_rules', function (Blueprint $table) {
            $table->string('schedule_mode')->default('interval');
            $table->json('send_days')->nullable();
            $table->json('send_times')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('alert_rules', function (Blueprint $table) {
            $table->dropColumn(['schedule_mode', 'send_days', 'send_times']);
        });
    }
};
