<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('alert_rules', function (Blueprint $table) {
            $table->date('track_date_from')->nullable()->after('renotify_every_hours');
            $table->date('track_date_to')->nullable()->after('track_date_from');
            $table->json('report_blocks')->nullable()->after('track_date_to');
        });
    }

    public function down(): void
    {
        Schema::table('alert_rules', function (Blueprint $table) {
            $table->dropColumn(['track_date_from', 'track_date_to', 'report_blocks']);
        });
    }
};
