<?php

namespace App\Providers;

use App\Models\CaseItem;
use App\Policies\CaseItemPolicy;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\AppSetting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::policy(CaseItem::class, CaseItemPolicy::class);

        try {
            $timezone = AppSetting::getValue('app.timezone');
            if ($timezone) {
                config(['app.timezone' => $timezone]);
                date_default_timezone_set($timezone);
            }
        } catch (\Throwable $e) {
            // Ignore if settings table is not ready yet.
        }
    }
}
