<?php

namespace App\Policies;

use App\Models\CaseItem;
use App\Models\User;

class CaseItemPolicy
{
    public function view(User $user, CaseItem $case): bool
    {
        if ($user->hasRole('Super Admin')) {
            return true;
        }

        if ($user->hasRole('Client Viewer')) {
            return (int) $user->client_id === (int) $case->client_id;
        }

        return $user->assignedClients()->whereKey($case->client_id)->exists();
    }

    public function create(User $user, ?int $clientId = null): bool
    {
        if ($user->hasRole('Super Admin')) {
            return true;
        }

        if ($user->hasRole('Client Viewer')) {
            return false;
        }

        if ($clientId === null) {
            return $user->assignedClients()->exists();
        }

        return $user->assignedClients()->whereKey($clientId)->exists();
    }

    public function update(User $user, CaseItem $case): bool
    {
        if ($user->hasRole('Super Admin')) {
            return true;
        }

        if ($user->hasRole('Client Viewer')) {
            return false;
        }

        return $user->assignedClients()->whereKey($case->client_id)->exists();
    }

    public function close(User $user, CaseItem $case): bool
    {
        if ($user->hasRole('Super Admin')) {
            return true;
        }

        if ($user->hasRole('Account Director')) {
            return $user->assignedClients()->whereKey($case->client_id)->exists();
        }

        return false;
    }
}
