<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CaseOption extends Model
{
    use HasFactory;

    protected $fillable = [
        'group',
        'value',
        'is_active',
        'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'sort_order' => 'integer',
        ];
    }

    public function clients()
    {
        return $this->belongsToMany(Client::class, 'client_case_options')
            ->withTimestamps();
    }
}
