<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CaseAlert extends Model
{
    use HasFactory;

    protected $fillable = [
        'case_id',
        'alert_rule_id',
        'notified_at',
        'next_notify_at',
        'notify_count',
    ];

    protected function casts(): array
    {
        return [
            'notified_at' => 'datetime',
            'next_notify_at' => 'datetime',
            'notify_count' => 'integer',
        ];
    }

    public function case()
    {
        return $this->belongsTo(CaseItem::class, 'case_id');
    }

    public function rule()
    {
        return $this->belongsTo(AlertRule::class, 'alert_rule_id');
    }
}
