<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AlertRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'is_global',
        'client_id',
        'enabled',
        'statuses',
        'trigger_actions',
        'threshold_hours',
        'check_every_minutes',
        'schedule_mode',
        'send_days',
        'send_times',
        'recipients_roles',
        'recipients_emails',
        'cc_client',
        'email_subject',
        'email_body',
        'renotify_every_hours',
        'track_date_from',
        'track_date_to',
        'report_blocks',
        'last_run_at',
    ];

    protected function casts(): array
    {
        return [
            'is_global' => 'boolean',
            'enabled' => 'boolean',
            'statuses' => 'array',
            'trigger_actions' => 'array',
            'recipients_roles' => 'array',
            'recipients_emails' => 'array',
            'cc_client' => 'boolean',
            'threshold_hours' => 'integer',
            'check_every_minutes' => 'integer',
            'schedule_mode' => 'string',
            'send_days' => 'array',
            'send_times' => 'array',
            'renotify_every_hours' => 'integer',
            'track_date_from' => 'date',
            'track_date_to' => 'date',
            'report_blocks' => 'array',
            'last_run_at' => 'datetime',
        ];
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function alerts()
    {
        return $this->hasMany(CaseAlert::class, 'alert_rule_id');
    }

    public function dispatchLogs()
    {
        return $this->hasMany(ReportDispatchLog::class, 'alert_rule_id');
    }

    public function latestDispatchLog()
    {
        return $this->hasOne(ReportDispatchLog::class, 'alert_rule_id')->latestOfMany('ran_at');
    }
}
