<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AppSetting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index(Request $request)
    {
        abort_unless($request->user()->can('clients.manage'), 403);

        $current = AppSetting::getValue('app.timezone', config('app.timezone'));

        return view('admin.settings.index', [
            'currentTimezone' => $current,
            'timezones' => \DateTimeZone::listIdentifiers(),
        ]);
    }

    public function update(Request $request)
    {
        abort_unless($request->user()->can('clients.manage'), 403);

        $data = $request->validate([
            'timezone' => ['required', 'string'],
        ]);

        AppSetting::setValue('app.timezone', $data['timezone']);

        return redirect()->route('admin.settings.index')->with('status', 'Timezone updated.');
    }
}
