<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Users</h2>
            <a href="{{ route('admin.users.create') }}" class="btn-primary">New User</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <form method="POST" action="{{ route('admin.users.bulk-destroy') }}" onsubmit="return confirm('Delete selected users?');">
                @csrf
                @method('DELETE')
                <div class="mb-3 flex justify-end">
                    <button class="inline-flex items-center px-3 py-2 text-sm rounded-md bg-rose-50 text-rose-700 hover:bg-rose-100 transition">Delete Selected</button>
                </div>
                <div class="card overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600">
                        <tr>
                            <th class="px-4 py-3 text-left"><input id="selectAllUsers" type="checkbox" class="rounded"></th>
                            <th class="px-4 py-3 text-left">Name</th>
                            <th class="px-4 py-3 text-left">Email</th>
                            <th class="px-4 py-3 text-left">Role</th>
                            <th class="px-4 py-3 text-left">Client</th>
                            <th class="px-4 py-3 text-left">Active</th>
                            <th class="px-4 py-3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($users as $user)
                            <tr class="border-t">
                                <td class="px-4 py-3"><input type="checkbox" name="ids[]" value="{{ $user->id }}" class="user-checkbox rounded"></td>
                                <td class="px-4 py-3">{{ $user->name }}</td>
                                <td class="px-4 py-3">{{ $user->email }}</td>
                                <td class="px-4 py-3">{{ $user->roles->first()?->name ?? '—' }}</td>
                                <td class="px-4 py-3">{{ $user->client->name ?? '—' }}</td>
                                <td class="px-4 py-3">{{ $user->is_active ? 'Yes' : 'No' }}</td>
                                <td class="px-4 py-3 text-right">
                                    <a href="{{ route('admin.users.edit', $user) }}" class="text-[color:var(--brand-primary)] hover:underline">Edit</a>
                                    <form method="POST" action="{{ route('admin.users.destroy', $user) }}" class="inline" onsubmit="return confirm('Delete this user?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="ml-2 text-rose-600 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-4 py-6 text-center text-gray-500">No users found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                </div>
            </form>
            <div class="mt-4">{{ $users->links() }}</div>
        </div>
    </div>
    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const selectAll = document.getElementById('selectAllUsers');
            const checkboxes = document.querySelectorAll('.user-checkbox');
            if (!selectAll) return;
            selectAll.addEventListener('change', () => {
                checkboxes.forEach((cb) => cb.checked = selectAll.checked);
            });
        });
    </script>
    @endpush
</x-app-layout>
