<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Edit User</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="card p-6">
                <form method="POST" action="{{ route('admin.users.update', $user) }}">
                    @csrf
                    @method('PUT')
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text" name="name" value="{{ old('name', $user->name) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                            @error('name')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Email</label>
                            <input type="email" name="email" value="{{ old('email', $user->email) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                            @error('email')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Password (leave blank to keep)</label>
                            <input type="password" name="password" class="mt-1 w-full border-gray-300 rounded-md" />
                            @error('password')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Role</label>
                            <select name="role" class="mt-1 w-full border-gray-300 rounded-md">
                                @foreach ($roles as $role)
                                    <option value="{{ $role->name }}" @selected($user->roles->first()?->name === $role->name)>{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Client (for Client Viewer)</label>
                            <select name="client_id" class="mt-1 w-full border-gray-300 rounded-md">
                                <option value="">None</option>
                                @foreach ($clients as $client)
                                    <option value="{{ $client->id }}" @selected($user->client_id == $client->id)>{{ $client->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Active</label>
                            <select name="is_active" class="mt-1 w-full border-gray-300 rounded-md">
                                <option value="1" @selected($user->is_active)>Yes</option>
                                <option value="0" @selected(!$user->is_active)>No</option>
                            </select>
                        </div>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-medium text-gray-700">Assign Clients (agency users)</label>
                        <select name="assigned_client_ids[]" multiple class="mt-1 w-full border-gray-300 rounded-md">
                            @foreach ($clients as $client)
                                <option value="{{ $client->id }}" @selected($user->assignedClients->pluck('id')->contains($client->id))>
                                    {{ $client->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mt-6 flex justify-end gap-2">
                        <a href="{{ route('admin.users.index') }}" class="btn-outline">Cancel</a>
                        <button class="btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
