@php
    $rule = $rule ?? null;
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Rule Name</label>
        <input type="text" name="name" value="{{ old('name', $rule->name ?? '') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">Enabled</label>
        <select name="enabled" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" @selected((int) old('enabled', $rule->enabled ?? 1) === 1)>Yes</option>
            <option value="0" @selected((int) old('enabled', $rule->enabled ?? 1) === 0)>No</option>
        </select>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Scope</label>
        <select id="scopeSelect" name="is_global" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" @selected((int) old('is_global', $rule->is_global ?? 1) === 1)>Global (all clients)</option>
            <option value="0" @selected((int) old('is_global', $rule->is_global ?? 1) === 0)>Per Client</option>
        </select>
    </div>
    <div id="clientSelectWrap">
        <label class="block text-sm font-medium text-gray-700">Client</label>
        <select name="client_id" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="">Select client</option>
            @foreach ($clients as $client)
                <option value="{{ $client->id }}" @selected((int) old('client_id', $rule->client_id ?? 0) === (int) $client->id)>{{ $client->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Check Interval (minutes)</label>
        <input id="checkIntervalInput" type="number" min="5" name="check_every_minutes" value="{{ old('check_every_minutes', $rule->check_every_minutes ?? 60) }}" class="mt-1 w-full border-gray-300 rounded-md" required>
        <div id="nextRunHint" class="text-xs text-blue-700 mt-1">Expected next run: —</div>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700">Re-notify Every (hours)</label>
        <input type="number" min="1" name="renotify_every_hours" value="{{ old('renotify_every_hours', optional($rule)->renotify_every_hours) }}" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">CC Client Default Emails</label>
        <select name="cc_client" class="mt-1 w-full border-gray-300 rounded-md">
            <option value="1" @selected((int) old('cc_client', $rule->cc_client ?? 0) === 1)>Yes</option>
            <option value="0" @selected((int) old('cc_client', $rule->cc_client ?? 0) === 0)>No</option>
        </select>
    </div>
</div>

<div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium text-gray-700">Track Cases From Date (optional)</label>
        <input type="date" name="track_date_from" value="{{ old('track_date_from', optional($rule)->track_date_from?->format('Y-m-d')) }}" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
    <div>
        <label class="block text-sm font-medium text-gray-700">Track Cases To Date (optional)</label>
        <input type="date" name="track_date_to" value="{{ old('track_date_to', optional($rule)->track_date_to?->format('Y-m-d')) }}" class="mt-1 w-full border-gray-300 rounded-md">
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Statuses that trigger this report</label>
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        @php $selectedStatuses = old('statuses', $rule->statuses ?? ['Open', 'In Progress', 'Waiting for User']); @endphp
        @foreach ($statuses as $status)
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="statuses[]" value="{{ $status }}" @checked(in_array($status, $selectedStatuses, true))>
                <span>{{ $status }}</span>
            </label>
        @endforeach
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Action Triggers (optional)</label>
    @php $selectedActions = old('trigger_actions', $rule->trigger_actions ?? []); @endphp
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        @foreach ($actions as $action)
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="trigger_actions[]" value="{{ $action }}" @checked(in_array($action, $selectedActions, true))>
                <span>{{ $action }}</span>
            </label>
        @endforeach
    </div>
    <div class="text-xs text-gray-500 mt-1">If selected, only cases with matching Action (Social Media Team) are included.</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Recipients by Role</label>
    @php $selectedRoles = old('recipients_roles', $rule->recipients_roles ?? []); @endphp
    <div class="mt-2 grid grid-cols-2 md:grid-cols-3 gap-2">
        @foreach ($roles as $role)
            <label class="text-sm inline-flex items-center gap-2">
                <input type="checkbox" name="recipients_roles[]" value="{{ $role }}" @checked(in_array($role, $selectedRoles, true))>
                <span>{{ $role }}</span>
            </label>
        @endforeach
    </div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Recipient Emails (search and add)</label>
    @php $selectedEmails = old('recipients_emails_selected', $rule->recipients_emails ?? []); @endphp
    <input id="emailSearchInput" type="text" class="mt-1 w-full border-gray-300 rounded-md" placeholder="Type email and press Enter">
    <datalist id="emailSuggestions">
        @foreach ($emailOptions as $email)
            <option value="{{ $email }}"></option>
        @endforeach
    </datalist>
    <div id="emailChips" class="mt-2 flex flex-wrap gap-2"></div>
    <div class="text-xs text-gray-500 mt-1">Press Enter to add. Click × to remove.</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Additional Recipient Emails (comma-separated)</label>
    <input type="text" name="recipients_emails" value="{{ old('recipients_emails', isset($rule) ? implode(',', $rule->recipients_emails ?? []) : '') }}" class="mt-1 w-full border-gray-300 rounded-md">
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Email Subject</label>
    <input type="text" name="email_subject" value="{{ old('email_subject', $rule->email_subject ?? 'Case Escalation Alert - {case_id}') }}" class="mt-1 w-full border-gray-300 rounded-md" required>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Email Body Template</label>
    <textarea name="email_body" rows="8" class="mt-1 w-full border-gray-300 rounded-md" required>{{ old('email_body', $rule->email_body ?? "Hello Team,\n\nHere is the automated case report.\nRule: {rule_name}\nScope: {scope}\nClient: {client_name}\nDate Range: {from_date} to {to_date}\nGenerated At: {generated_at}\n\nTotals\n- Total Cases: {total_cases}\n- Open Cases: {open_cases}\n- Closed Cases: {closed_cases}\n- Critical Cases: {critical_cases}") }}</textarea>
    <div class="text-xs text-gray-500 mt-1">Variables: {rule_name}, {scope}, {client_name}, {from_date}, {to_date}, {total_cases}, {open_cases}, {closed_cases}, {critical_cases}, {generated_at}</div>
</div>

<div class="mt-4">
    <label class="block text-sm font-medium text-gray-700">Report Content Blocks (drag to reorder)</label>
    @php
        $selectedBlocks = old('report_blocks_json')
            ? (json_decode(old('report_blocks_json'), true) ?: [])
            : ($rule->report_blocks ?? ['custom_message', 'summary_kpis', 'open_cases_table', 'closed_cases_table']);
    @endphp
    <input type="hidden" id="reportBlocksJson" name="report_blocks_json" value="{{ old('report_blocks_json', json_encode($selectedBlocks)) }}">
    <div class="mt-2 grid grid-cols-1 lg:grid-cols-2 gap-4">
        <div class="rounded-lg border border-gray-200 p-3">
            <div class="text-xs text-gray-500 mb-2">Selected Blocks</div>
            <ul id="selectedBlocksList" class="space-y-2"></ul>
        </div>
        <div class="rounded-lg border border-gray-200 p-3">
            <div class="text-xs text-gray-500 mb-2">Available Blocks</div>
            <ul id="availableBlocksList" class="space-y-2"></ul>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const scope = document.getElementById('scopeSelect');
        const wrap = document.getElementById('clientSelectWrap');
        if (!scope || !wrap) return;
        const sync = () => wrap.style.display = scope.value === '1' ? 'none' : 'block';
        sync();
        scope.addEventListener('change', sync);

        const searchInput = document.getElementById('emailSearchInput');
        const chipsWrap = document.getElementById('emailChips');
        const initial = @json(array_values(array_unique($selectedEmails)));
        if (!searchInput || !chipsWrap) return;

        searchInput.setAttribute('list', 'emailSuggestions');
        const selected = new Set(initial);

        const validateEmail = (value) => /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);

        const render = () => {
            chipsWrap.innerHTML = '';
            selected.forEach((email) => {
                const chip = document.createElement('span');
                chip.className = 'inline-flex items-center gap-2 px-2 py-1 rounded-full text-xs bg-blue-50 text-blue-700';
                chip.textContent = email;

                const btn = document.createElement('button');
                btn.type = 'button';
                btn.className = 'text-blue-900';
                btn.textContent = '×';
                btn.addEventListener('click', () => {
                    selected.delete(email);
                    render();
                });

                const hidden = document.createElement('input');
                hidden.type = 'hidden';
                hidden.name = 'recipients_emails_selected[]';
                hidden.value = email;

                chip.appendChild(btn);
                chipsWrap.appendChild(chip);
                chipsWrap.appendChild(hidden);
            });
        };

        searchInput.addEventListener('keydown', (e) => {
            if (e.key !== 'Enter') return;
            e.preventDefault();
            const value = searchInput.value.trim();
            if (!value || !validateEmail(value)) return;
            selected.add(value);
            searchInput.value = '';
            render();
        });

        render();

        const blockMap = @json($blockOptions);
        const selectedInput = document.getElementById('reportBlocksJson');
        const selectedList = document.getElementById('selectedBlocksList');
        const availableList = document.getElementById('availableBlocksList');
        if (!selectedInput || !selectedList || !availableList) return;

        let selectedBlocks = [];
        try {
            selectedBlocks = JSON.parse(selectedInput.value || '[]');
        } catch (e) {
            selectedBlocks = [];
        }
        if (!Array.isArray(selectedBlocks) || selectedBlocks.length === 0) {
            selectedBlocks = ['custom_message', 'summary_kpis', 'open_cases_table', 'closed_cases_table'];
        }

        const allKeys = Object.keys(blockMap);

        const updateHidden = () => {
            selectedInput.value = JSON.stringify(selectedBlocks);
        };

        const makeItem = (key, isSelected) => {
            const li = document.createElement('li');
            li.className = 'flex items-center justify-between gap-2 px-3 py-2 rounded-md border text-sm bg-white';
            li.draggable = isSelected;
            li.dataset.key = key;
            li.innerHTML = `<span>${blockMap[key] ?? key}</span>`;

            const btn = document.createElement('button');
            btn.type = 'button';
            btn.className = 'text-xs px-2 py-1 rounded bg-blue-50 text-blue-700';
            btn.textContent = isSelected ? 'Remove' : 'Add';
            btn.addEventListener('click', () => {
                if (isSelected) {
                    selectedBlocks = selectedBlocks.filter(v => v !== key);
                } else if (!selectedBlocks.includes(key)) {
                    selectedBlocks.push(key);
                }
                renderBlocks();
            });
            li.appendChild(btn);

            if (isSelected) {
                li.addEventListener('dragstart', (e) => {
                    e.dataTransfer.setData('text/plain', key);
                });
            }

            return li;
        };

        selectedList.addEventListener('dragover', (e) => e.preventDefault());
        selectedList.addEventListener('drop', (e) => {
            e.preventDefault();
            const draggedKey = e.dataTransfer.getData('text/plain');
            const targetLi = e.target.closest('li');
            if (!draggedKey || !targetLi) return;
            const targetKey = targetLi.dataset.key;
            if (!selectedBlocks.includes(draggedKey) || !selectedBlocks.includes(targetKey)) return;
            selectedBlocks = selectedBlocks.filter(v => v !== draggedKey);
            const targetIndex = selectedBlocks.indexOf(targetKey);
            selectedBlocks.splice(targetIndex, 0, draggedKey);
            renderBlocks();
        });

        const renderBlocks = () => {
            selectedList.innerHTML = '';
            availableList.innerHTML = '';
            selectedBlocks.forEach((key) => selectedList.appendChild(makeItem(key, true)));
            allKeys.filter(k => !selectedBlocks.includes(k)).forEach((key) => availableList.appendChild(makeItem(key, false)));
            updateHidden();
        };

        renderBlocks();

        const intervalInput = document.getElementById('checkIntervalInput');
        const nextRunHint = document.getElementById('nextRunHint');
        const lastRunAt = @json(optional($rule)->last_run_at?->toIso8601String());

        const computeHint = () => {
            if (!intervalInput || !nextRunHint) return;
            const mins = parseInt(intervalInput.value || '0', 10);
            if (!mins || mins < 1) {
                nextRunHint.textContent = 'Expected next run: invalid interval';
                return;
            }

            const base = lastRunAt ? new Date(lastRunAt) : new Date();
            const next = new Date(base.getTime() + mins * 60000);
            const hrs = (mins / 60).toFixed(mins % 60 === 0 ? 0 : 1);
            nextRunHint.textContent = `Expected next run: every ${mins} min (~${hrs}h). Next around ${next.toLocaleString()}`;
        };

        if (intervalInput) intervalInput.addEventListener('input', computeHint);
        computeHint();
    });
</script>
@endpush
