<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Edit Client</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="card p-6">
                <form method="POST" action="{{ route('admin.clients.update', $client) }}">
                    @csrf
                    @method('PUT')
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text" name="name" value="{{ old('name', $client->name) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                            @error('name')<div class="text-sm text-rose-600">{{ $message }}</div>@enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" class="mt-1 w-full border-gray-300 rounded-md">
                                <option value="active" @selected($client->status === 'active')>Active</option>
                                <option value="inactive" @selected($client->status === 'inactive')>Inactive</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Timezone</label>
                            <input type="text" name="timezone" value="{{ old('timezone', $client->timezone) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Default Notification Emails (comma separated)</label>
                            <input type="text" name="default_notification_emails" value="{{ old('default_notification_emails', implode(',', $client->default_notification_emails ?? [])) }}" class="mt-1 w-full border-gray-300 rounded-md" />
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Allowed Labels</label>
                            <select name="label_ids[]" multiple class="mt-1 w-full border-gray-300 rounded-md">
                                @foreach ($labels as $label)
                                    <option value="{{ $label->id }}" @selected($client->labelOptions->pluck('id')->contains($label->id))>
                                        {{ $label->value }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="text-xs text-gray-500 mt-1">If none selected, all labels are allowed.</div>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-end gap-2">
                        <a href="{{ route('admin.clients.index') }}" class="btn-outline">Cancel</a>
                        <button class="btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
