<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Client Assignments</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <form method="POST" action="{{ route('admin.assignments.update') }}" class="card p-6">
                @csrf
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead>
                            <tr class="border-b text-gray-600">
                                <th class="px-4 py-2 text-left">User</th>
                                @foreach ($clients as $client)
                                    <th class="px-4 py-2 text-center">{{ $client->name }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                                <tr class="border-b">
                                    <td class="px-4 py-2">
                                        <div class="font-medium">{{ $user->name }}</div>
                                        <div class="text-xs text-gray-500">{{ $user->roles->first()?->name ?? '—' }}</div>
                                    </td>
                                    @foreach ($clients as $client)
                                        <td class="px-4 py-2 text-center">
                                            <input
                                                type="checkbox"
                                                name="assignments[{{ $user->id }}][]"
                                                value="{{ $client->id }}"
                                                @checked($user->assignedClients->pluck('id')->contains($client->id))
                                                class="rounded"
                                            />
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4 flex justify-end">
                    <button class="btn-primary">Save Assignments</button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
