<?php

namespace Database\Seeders;

use App\Models\CaseItem;
use App\Models\CaseOption;
use App\Models\Client;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SampleDataSeeder extends Seeder
{
    public function run(): void
    {
        $client = Client::firstOrCreate(
            ['name' => 'Skyline Airways'],
            [
                'status' => 'active',
                'timezone' => 'UTC',
                'default_notification_emails' => ['alerts@skyline.example'],
            ]
        );

        $superAdmin = User::firstOrCreate(
            ['email' => 'admin@agency.test'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password'),
                'is_active' => true,
            ]
        );
        $superAdmin->assignRole('Super Admin');

        $accountDirector = User::firstOrCreate(
            ['email' => 'director@agency.test'],
            [
                'name' => 'Account Director',
                'password' => Hash::make('password'),
                'is_active' => true,
            ]
        );
        $accountDirector->assignRole('Account Director');
        $accountDirector->assignedClients()->syncWithoutDetaching([$client->id]);

        $communityMember = User::firstOrCreate(
            ['email' => 'community@agency.test'],
            [
                'name' => 'Community Team',
                'password' => Hash::make('password'),
                'is_active' => true,
            ]
        );
        $communityMember->assignRole('Community Team Member');
        $communityMember->assignedClients()->syncWithoutDetaching([$client->id]);

        $clientViewer = User::firstOrCreate(
            ['email' => 'viewer@client.test'],
            [
                'name' => 'Client Viewer',
                'password' => Hash::make('password'),
                'client_id' => $client->id,
                'is_active' => true,
            ]
        );
        $clientViewer->assignRole('Client Viewer');

        $labelIds = CaseOption::query()
            ->where('group', 'label')
            ->whereIn('value', ['KA-Delayed', 'KA-Complaints', 'KA-Carrier Complaint'])
            ->pluck('id')
            ->all();
        $client->labelOptions()->sync($labelIds);

        CaseItem::firstOrCreate(
            ['client_id' => $client->id, 'created_by' => $communityMember->id, 'label' => 'KA-Delayed'],
            [
                'source' => 'Community Management (Direct Mentions)',
                'sentiment' => 'Negative',
                'post_date' => now()->toDateString(),
                'post_text' => 'My flight is delayed again. What is happening?',
                'post_link' => 'https://example.com/post/123',
                'action_social' => 'Pending Information',
                'notes_social' => 'Awaiting details from ops team.',
                'status' => 'Open',
            ]
        );
    }
}
