<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('client_case_options', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained('clients')->cascadeOnDelete();
            $table->foreignId('case_option_id')->constrained('case_options')->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['client_id', 'case_option_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('client_case_options');
    }
};
