<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cases', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained('clients')->cascadeOnDelete();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->string('label');
            $table->string('source');
            $table->string('sentiment');
            $table->date('post_date');
            $table->time('post_time')->nullable();
            $table->text('post_text')->nullable();
            $table->text('translation')->nullable();
            $table->string('post_link')->nullable();
            $table->string('action_social')->nullable();
            $table->text('notes_social')->nullable();
            $table->text('user_reply')->nullable();
            $table->string('status')->default('Open');
            $table->timestamp('last_status_changed_at')->nullable();
            $table->timestamp('closed_at')->nullable();
            $table->timestamp('last_notified_at')->nullable();
            $table->string('escalation_state')->default('none');
            $table->timestamps();

            $table->index(['client_id', 'status']);
            $table->index(['sentiment', 'status']);
            $table->index(['label', 'source']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cases');
    }
};
