<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportDispatchLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'alert_rule_id',
        'ran_at',
        'status',
        'recipient_count',
        'case_count',
        'is_manual',
        'note',
    ];

    protected function casts(): array
    {
        return [
            'ran_at' => 'datetime',
            'is_manual' => 'boolean',
        ];
    }

    public function rule()
    {
        return $this->belongsTo(AlertRule::class, 'alert_rule_id');
    }
}
