<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomField extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'type',
        'options',
        'is_required',
        'is_active',
        'show_in_filters',
        'show_in_exports',
        'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'options' => 'array',
            'is_required' => 'boolean',
            'is_active' => 'boolean',
            'show_in_filters' => 'boolean',
            'show_in_exports' => 'boolean',
        ];
    }

    public function values()
    {
        return $this->hasMany(CaseCustomFieldValue::class, 'custom_field_id');
    }
}
