<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'status',
        'timezone',
        'default_notification_emails',
    ];

    protected function casts(): array
    {
        return [
            'default_notification_emails' => 'array',
        ];
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function assignedUsers()
    {
        return $this->belongsToMany(User::class, 'client_user_assignments')
            ->withTimestamps();
    }

    public function cases()
    {
        return $this->hasMany(CaseItem::class, 'client_id');
    }

    public function labelOptions()
    {
        return $this->belongsToMany(CaseOption::class, 'client_case_options')
            ->withTimestamps();
    }
}
