<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CaseCustomFieldValue extends Model
{
    use HasFactory;

    protected $fillable = [
        'case_id',
        'custom_field_id',
        'value',
    ];

    public function case()
    {
        return $this->belongsTo(CaseItem::class, 'case_id');
    }

    public function field()
    {
        return $this->belongsTo(CustomField::class, 'custom_field_id');
    }
}
