<?php

namespace App\Mail;

use App\Models\AlertRule;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CaseReportSummaryMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public AlertRule $rule,
        public string $renderedBody,
        public array $clientInfo,
        public array $summary,
        public array $statusBreakdown,
        public array $sentimentBreakdown,
        public array $criticalCases,
        public array $openCases,
        public array $closedCases,
        public array $blocks,
        public string $subjectLine
    ) {}

    public function build(): self
    {
        return $this->subject($this->subjectLine)
            ->view('emails.case-report-summary')
            ->with([
                'rule' => $this->rule,
                'renderedBody' => $this->renderedBody,
                'clientInfo' => $this->clientInfo,
                'summary' => $this->summary,
                'statusBreakdown' => $this->statusBreakdown,
                'sentimentBreakdown' => $this->sentimentBreakdown,
                'criticalCases' => $this->criticalCases,
                'openCases' => $this->openCases,
                'closedCases' => $this->closedCases,
                'blocks' => $this->blocks,
            ]);
    }
}
