<?php

namespace App\Http\Controllers;

use App\Models\CaseItem;
use App\Models\User;
use Illuminate\Http\Request;

class CaseOwnerController extends Controller
{
    public function update(Request $request, CaseItem $case)
    {
        $this->authorize('update', $case);

        $ownerIds = $request->input('owner_ids', []);
        if (!is_array($ownerIds)) {
            $ownerIds = [];
        }

        $user = $request->user();
        $visibleOwnerIds = User::query()
            ->whereDoesntHave('roles', fn ($q) => $q->where('name', 'Client Viewer'))
            ->when(!$user->hasRole('Super Admin'), function ($query) use ($case) {
                $query->whereHas('assignedClients', fn ($q) => $q->where('clients.id', $case->client_id));
            })
            ->whereIn('id', $ownerIds)
            ->pluck('id')
            ->all();

        $case->owners()->sync($visibleOwnerIds);

        return redirect()->route('cases.show', $case)->with('status', 'Owners updated.');
    }
}
